/*
 * Created on 30-giu-2004
 *
 * 
 */
package Gui;


import javax.swing.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.border.*;
import javax.swing.tree.*;
import DFSS.*;

/**
 * @author Dario Agostinone
 *
 * 
 * 
 */
public class ClientGui extends JFrame{
	
	private class windowlistener implements WindowListener {
		
        
		   public void windowActivated(WindowEvent e)
		   {
		   }
        
			public void windowClosed(WindowEvent e)
		   {
		   }
        
			public void windowClosing(WindowEvent e)
		   {
			   System.exit(0);
		   }
        
			public void windowDeactivated(WindowEvent e)
		   {
		   }
        
			public void windowDeiconified(WindowEvent e)
		   {
		   }
        
			public void windowIconified(WindowEvent e)
		   {
		   }
        
			public void windowOpened(WindowEvent e)
		   {
		   }
	   }

    
    protected  CreaDirectory listener ;
    protected CreaFile listenerCreaFile;
    protected RimuoviDirectory listenerRimozione;
	protected DefaultTreeModel treeModel;
 	protected JPanel TreePanel;
	protected JPanel CommandPanel;
	protected JTextArea output;
	protected JTextField nomeDirectory;
	protected JTree tree;
	protected JButton creaFile;
	protected JButton rimuoviFile;
	protected JButton aggiorna;
	protected RimuoviFile listenerRimozioneFile; 
	protected HostID ip;
	protected DownLoadFile listenerDownload ;
	protected FileUpload listenerUpload;
	protected ViewDirectory listenerView;
	protected String home;
	
	
	public ClientGui(Directory Dir,HostID ip,String home)
	{
		super("ClientDFSS @ address : "+ip);
		this.ip=ip;
		this.home=home;
		listenerView=new ViewDirectory(this);
		listener=new CreaDirectory(this);
		listenerRimozione=new RimuoviDirectory(this);
		listenerDownload = new DownLoadFile(this);
		listenerUpload=new FileUpload(this);
		output=new JTextArea(20,20);
		setSize(640,480);
		windowlistener list = new windowlistener();
		tree =new JTree();
		rimuoviFile = new JButton("Rimuovi File");
		listenerRimozioneFile=new RimuoviFile(this);
		rimuoviFile.addActionListener(listenerRimozioneFile);
		this.addWindowListener(list);
		aggiorna=new JButton("Aggiorna Cartelle");
		aggiorna.addActionListener(listenerView);
		TreePanel = new JPanel();
		CommandPanel = new JPanel();
		this.getContentPane().setLayout(new GridLayout(1,2));
		TreePanel.setLayout(new GridLayout(2,1));
		tree.setSize(TreePanel.getSize());
		TreePanel.add(tree);
		TreePanel.add(output);
		listenerCreaFile = new CreaFile(this);
		aggiornaDirectory(Dir); 
		TreePanel.setBorder(new LineBorder(Color.black,2));
		CommandPanel.setBorder(new LineBorder(Color.black,2));
	 nomeDirectory = new JTextField(20);
		JButton creaDirectory = new JButton("Crea Directory");
		creaDirectory.addActionListener(listener);
		JButton rimuoviDirectory = new JButton("Rimuovi Directory");
		creaFile = new JButton("Crea Nuovo File");
		creaFile.addActionListener(listenerCreaFile);
		JButton DownLoad = new JButton("Download File ... ");
		JButton upload =new JButton(" Upload di un file ");
		upload.addActionListener(listenerUpload); 
		DownLoad.addActionListener(listenerDownload);
		rimuoviDirectory.addActionListener(listenerRimozione);
		CommandPanel.setLayout(new GridLayout(10,1));
		CommandPanel.add(nomeDirectory);
		CommandPanel.add(aggiorna);
		CommandPanel.add(creaDirectory);
		CommandPanel.add(rimuoviDirectory);
		CommandPanel.add(creaFile);
		CommandPanel.add(rimuoviFile);
		CommandPanel.add(DownLoad);
		CommandPanel.add(upload);
		this.getContentPane().add(TreePanel);
		this.getContentPane().add(CommandPanel);
		this.repaint();
		this.show();
	}
	
	public HostID getServerIp()
	{
		return ip;
	}
	
	public String getHome()
	{
		return home;
	}
	
	public String getNomeDirectory()
	{
		String out = nomeDirectory.getText();
		nomeDirectory.setText("");
		return out;
	}
	public void print(String s)
	{
		output.append(s);
	}
	
	public void aggiornaDirectory(Directory dir)
	{
		treeModel=createModel(dir);
		tree.setModel(treeModel);
		repaint();
	}
	
	
	
	private DefaultTreeModel createModel(Directory Dir)
		{
			DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root"); 
			root.setAllowsChildren(true);
			Enumeration enum = Dir.getSottoDirectory();
			while(enum.hasMoreElements()) 
			{				
				root.add(createTreeNode((Directory)enum.nextElement()));
			}
			DefaultTreeModel out = new DefaultTreeModel(root);
			out.setAsksAllowsChildren(true);
			return( out);
		}
		private DefaultMutableTreeNode createTreeNode( Directory p)
		{
			DefaultMutableTreeNode comp= new DefaultMutableTreeNode(p.getPath());
			comp.setAllowsChildren(true);
			Enumeration en = p.getSottoDirectory();
			while(en.hasMoreElements()) 
			{
				comp.add(createTreeNode((Directory)en.nextElement()));
			}
			Enumeration fs =p.getFiles();
			while(fs.hasMoreElements())
			{
				DefaultMutableTreeNode temp =new DefaultMutableTreeNode((String)fs.nextElement());
				temp.setAllowsChildren(false);
				comp.add(temp);
			}
			return comp;
		}

   	  

}
