/*
 * Created on 3-lug-2004
 *
 * 
 */
package FRS;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.io.*;
import DFSS.*;
/**
 * @author Dario Agostinone
 *
 *   Proxy scrittura
 * 
 */
public class proxyScrittura
	extends UnicastRemoteObject
	implements ISessioneScrittura {
 
    // apth fisico del file
	protected String path;
	//path logico del file
	protected String lpath;
	// buffer dove vengono memorizzati i byte prima di essere salvati sul file
	protected ByteArrayOutputStream buffer ;
	// Stream di output
    protected FileOutputStream output1 ;
    // gestore del rilascio delle risorse
    protected ITerminazioneSessione res;
    // clone
    protected ISessioneScrittura clone;
    // true se si effettua una modifica in coda al file
    protected boolean append;
    // monitor dell'esecuzione
    protected IExecutionMonitor monitor;
    // cliente
 	protected IClientCallBack client;
 	
 	/**
 	 * 
 	 * Costruttore
 	 */   
	public proxyScrittura(String logicalpath,String path,boolean append,ITerminazioneSessione listTerm,IClientCallBack client,IExecutionMonitor monitor ) throws RemoteException
	{
		try
		{
		 this.path=path;
		 this.append=append;
		 this.monitor=monitor;
		 this.client=client;
		 lpath=logicalpath;
		 buffer = new ByteArrayOutputStream();
		 clone=null;
		 this.res=listTerm;
		 
		}catch(Exception e)
		{
			throw new RemoteException("Errore durante la creazione del proxy di scrittura",e);
		}
	}
	
	/**
	 * 
	 * setto il clone
	 */
	public void setClone(ISessioneScrittura in) throws RemoteException
	{
		clone=in;
	}
	
	/**
	 * 
	 * scrive il buffer buf sul file
	 */
	public void scrivi(String buf) throws RemoteException {
        try{
        	if (clone!=null)
        	  {
        	  	// solo il proxy principlae invia messaggi al monitor
        	  	monitor.addLog(new LogInformation(lpath,ResourceManager.WRITE,this,System.currentTimeMillis(),client));
        	  } 	
        	// memorizzo il buffer  
        	for (int i=0 ; i<buf.length(); i++)
        	{
        						buffer.write(buf.charAt(i));
        	}
        	if (clone!=null)
        	  {
        	  	// se esiste un proxy come clone effettuo il CheckPoint
        	  	clone.scrivi(buf);
        	  }
        }catch(Exception e)
        {
        	throw new RemoteException("Errore durante la fase di scrittura del file ",e);
        }
	}

	/**
	 * 
	 * Resetto la scrittura
	 */
	public void Reset() throws RemoteException {
		if (clone!=null)
			  {
			  	//invio il log al monitor
				monitor.addLog(new LogInformation(lpath,ResourceManager.WRITE,this,System.currentTimeMillis(),client));
			  } 	
		// ricreo il buffer
		buffer = new ByteArrayOutputStream();
		if(clone!=null)
              clone.Reset();// checkpoint 
	}

	/**
	 * 
	 * Terminazione forzata a fronte di anomalia
	 */
	public void TerminazioneForzata() throws RemoteException
	{
	  try
	  {
	  	//il file viene solo rilasciato, e no salvato sulla copia su disco
		buffer.close();
		if (clone!=null)
		 {
		 	// rilascio del file , viene effettuato dal proxy principale
			res.rilasciaFile(lpath,ResourceManager.WRITE);
		 }
	  }catch (Exception e)
	  {
	  	throw new RemoteException(" Errore durante la terminazione Forzata",e);
	  }
	}
	 
	/**
	 * 
	 * Terminazione della sessione
	 */
	public void Termina() throws RemoteException {
		if (clone!=null)
			  {
			  	//invion un log
				monitor.addLog(new LogInformation(lpath,ResourceManager.WRITE,this,System.currentTimeMillis(),client));
			  } 	
         try
         {
         // scrivo i byte , sul file fisico
		 output1 = new FileOutputStream(path,append);
		 output1.write(buffer.toByteArray());
		 output1.close();
		 buffer.close();
         if (clone!=null)
         {	
         	//rilascio la risorsa
         	res.rilasciaFile(lpath,ResourceManager.WRITE);
         	//termino il clone
         	clone.Termina();
         	// rimuovo dall'elenco dei log la sessione
            monitor.remove(this);
         } 
         }catch(Exception e )
         {
         	throw new RemoteException("Errore durante il rilascio della risorsa ",e); 
         	
         }
	}

}
