/*
 * Created on 3-lug-2004
 *
 * 
 */
package FRS;

import DFSS.*;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.io.*;


/**
 * @author Dario Agostinone
 *
 *  Proxy Lettura
 * 
 */
public class proxyLettura
	extends UnicastRemoteObject
	implements ISessioneLettura {

	 //path fisico del file al quale accedere
	 protected String path;
	 //path logico del file
     protected String lpath;
     // stream di ingresso dal quale viene letto il file
	 protected FileInputStream inStream;
	 // gestore del rilascio delle risorse
	 protected ITerminazioneSessione res ;
     // Riferimento remoto all'execution monitor
	 protected IExecutionMonitor monitor;
	 //riferimento remoto al cliente
	 protected IClientCallBack client;
	 
	 /**
	  * 
	  * Costruttore
	  */
	 public proxyLettura(String logicalpath,String path, ITerminazioneSessione res,IClientCallBack client ,IExecutionMonitor monitor ) throws RemoteException
	 {
	 	try
	 	{
	 	this.res = res;
		this.path = path;
		lpath=logicalpath;
		inStream=new FileInputStream(path);
		this.monitor=monitor;
		this.client=client;
		this.monitor.addLog(new LogInformation(lpath,ResourceManager.READ,this,System.currentTimeMillis(),this.client));
	 	}catch (Exception e)
	 	{
	 		throw new RemoteException("Errore creazione proxy di lettura ",e);
	 	}
	 }
	
	/**
	 * 
	 * legge dimbuf caratteri dal file
	 */ 
	public String leggi(int DimBuf) throws RemoteException {
		//aggiunge un log al monitor
		monitor.addLog(new LogInformation(lpath,ResourceManager.READ,this,System.currentTimeMillis(),this.client));
		try{
			//esegue l'operazione
			int i=0;
			String ret = "";
			while((i<DimBuf)&&((inStream.available())>0))
			{
				i++;
				char letto = (char) inStream.read();
				ret=ret+letto;
			}
			//restituisce il buffer
			return ret;
		}catch(Exception e)
		{
		   throw new RemoteException(" Errore durante la lettura dal file ",e);
		}
	}
	
	/**
	 * 
	 *  Termina forzatamente la sessione
	 */
	public void TerminazioneForzata() throws RemoteException
	{
		// rilascia semplicemente la risorsa
		Termina();
	}

	/**
	 * 
	 * Restituisce true se vi sono ancora caratteri da leggere dal file
	 */
	public boolean avaible() throws RemoteException {
		//aggiunge il log del file
		monitor.addLog(new LogInformation(lpath,ResourceManager.READ,this,System.currentTimeMillis(),this.client));
		try{
		boolean res = ((inStream.available())>0);
		return (res);
		}catch(IOException e){
			throw new RemoteException("Errore accesso al file",e);
		}
	}

	/**
	 * 
	 * Resetta la sessione
	 */
	public void Reset() throws RemoteException {
		
		try
		{  // aggiunge un log
		   monitor.addLog(new LogInformation(lpath,ResourceManager.READ,this,System.currentTimeMillis(),this.client));
		   inStream.close();
           inStream = new FileInputStream(this.path);
		}catch (Exception e)
		{
			throw new RemoteException(" Errore nel reset della sessione di lettura ",e);
		}
	}

	/**
	 * 
	 * Termina la sessione rilasciando la risorsa
	 */
	public void Termina() throws RemoteException {
		// aggiunge il log
		monitor.addLog(new LogInformation(lpath,ResourceManager.READ,this,System.currentTimeMillis(),this.client));
		try {
			// chiude lo stream di input
			inStream.close();
			//rilascia il file
			res.rilasciaFile(lpath,ResourceManager.READ);
			//elimina la sessione dai log
			monitor.remove(this);
		}catch(Exception e)
		{
			throw new RemoteException("Errore durante il rilascio del proxy ",e);
		}
	}

}
