/*
 * Created on 9-lug-2004
 *
 * 
 */
package FRS;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.*;
import java.io.*;
import DFSS.*;
/**
 * @author Dario Agostinone
 *
 *  Implementazione del Repository
 * 
 */
public class defaultRepository
	extends UnicastRemoteObject
	implements IRepository {
		
		//directory locale dove vengono memorizzati i file
		protected String home;
		
		/**
		 * 
		 * Costruttore
		 */
		public defaultRepository( String home) throws RemoteException 
		{
			this.home=home;
		}
		
		/**
		 * 
		 * Crea un file nel repository
		 */
		public void createFile(String path) throws RemoteException
		{
			// i file vengono memorizzati con un nome dato dal path con la sostituzione di "/" con "_"
			String location = home+"/"+ path.replaceAll("/","_");
		    File temp = new File(location);
		    try
		    {
		    	//creo il file
		    	temp.createNewFile();
		    }catch(Exception e )
		    {
		    	throw new RemoteException(" Repository : Errore durante la creazione del file",e);
		    }
		}
		
		/**
		 * 
		 * cancella un file presente nel repository
		 */
		public void deleteFile(String path) throws RemoteException
		{
			String location = home+"/"+ path.replaceAll("/","_");
			File temp = new File(location);
			try
			{
			  //elimino il file
			  if (temp.exists()) temp.delete();
			}catch(Exception e )
			   {
						   throw new RemoteException(" Repository : Errore durante la creazione del file",e);
			   }
		}
		
		/**
		 * crea un proxy di scrittura
		 */
	    public  ISessioneScrittura createProxyScrittura(String path,boolean append,ITerminazioneSessione termList,IClientCallBack client,IExecutionMonitor monitor) throws RemoteException
	    {
			String location = home+"/"+ path.replaceAll("/","_");
	    	proxyScrittura proxy = new proxyScrittura(path,location,append,termList,client,monitor);
	    	return proxy;
	    }
	    
	    /**
	     * 
	     * crea un proxy di lettura
	     */
		public  ISessioneLettura createProxyLettura(String path,ITerminazioneSessione termList,IClientCallBack client,IExecutionMonitor monitor) throws RemoteException
				{
					String location = home+"/"+ path.replaceAll("/","_");
					proxyLettura proxy = new proxyLettura(path,location,termList,client,monitor);
					return proxy;
				}
        
        /**
         * 
         * creazione del repository
         *
         */
        public static void main(String args[])
        {
        	if (args.length!=4) 
        	        {
        	        	System.out.println("Errore numero di argomenti errato servono :  path - ipRepositoryServer ");
        	            System.exit(0);
        	        } 
        	try
        	{        
        		if (System.getSecurityManager()==null)
        	   	{
        	   	    System.setSecurityManager(new RMISecurityManager());
        	   	}
        	   	// stringa di connesione del repository
        		String completeName = "//"+args[2]+":1099/"+args[0];
        		defaultRepository rep = new defaultRepository(args[1]);
        		// stringa di connessione al repository server
        		String completeNameRep = "//"+args[3]+":1099/FRS";
        		// binding
        		Naming.rebind(completeName,rep);
        		// accesso al repository server
        		IFileRepositoryServer repServer  =(IFileRepositoryServer) Naming.lookup(completeNameRep); 
        		repServer.registra(args[0],args[2]);
        		System.out.println("Servizio avviato");
        	}catch (Exception e )
        	{
        		System.out.println("Errore nell'avvio del repository"+e);
        	}
        }
}
