/*
 * Created on 14-lug-2004
 *
 * 
 */
package FRS;

import java.util.*;

/**
 * @author Dario Agostinone
 *
 *   Thread che esegue periodicamente il controllo dei log di un nmonitor
 * 
 */
public class ThreadMonitor extends Thread {
	
	// monitor associato
	protected  ExecutionMonitor monitor;
	// riferimento al resource Manager
	protected  ResourceManager resManager;
	
	/**
	 * 
	 * Costruttore
	 */
	public ThreadMonitor(ExecutionMonitor monitor, ResourceManager res)
    {
    	this.monitor=monitor;
    	resManager = res;
    }
    /**
     * 
     * Metodo run
     */
    public void run()
    {
    	try
    	{
    	
    	while (true)
    	{
    		sleep(ExecutionMonitor.CONTROL);
    		// carico l'elenco dei log
    		Enumeration logs = monitor.getLogs();
    	    while(logs.hasMoreElements())
    	    {
    	    	// leggo un log
    	    	LogInformation log = (LogInformation) logs.nextElement();
    	    	long temp = System.currentTimeMillis();
    	    	// controllo se non  passato il tIMEOUT rispetto all'istante corrente
    	    	System.out.println("TimeStamp corrente "+log.getTimeStamp());
    	    	if((temp-log.getTimeStamp())>(ExecutionMonitor.TIMEOUT))
    	    	{
    	    		System.out.println("Sessione caduta "+log.getSessione()+" tempo trascorso "+(temp-log.getTimeStamp()));
    	    		monitor.remove(log.getSessione());
    	    		resManager.rilasciaFile(log.getFilePath(),log.getSessionType());
    	    	}
    	    }
    	}
    	}catch(Exception e)
    	{
    	}
    }
}
