/*
 * Created on 3-lug-2004
 *
 * 
 */
package FRS;

import DFSS.*;
import java.util.*;
import java.io.*;
import java.rmi.server.*;
import java.rmi.*;
/**
 * @author Dario Agostinone
 *
 *   ResourceManager : Incapsula le politiche di accesso alle risorse 
 * 
 */
public class ResourceManager extends UnicastRemoteObject implements ITerminazioneSessione {
    
    /**
     * 
     * @author Dario Agostinone
     *
     *  classe che mantiene le informazioni di una richiesta, utilizzata per le code
     *
     */
    private class richiesta
    {
    	// cliente che ha effettuato la richiesta
    	private IClientCallBack client;
    	//tipo della richiesta
    	private int type;
    	
    	/**
    	 * 
    	 * Costruttore
    	 */
    	public richiesta(IClientCallBack client , int type )
    	{
    		this.type=type;
    		this.client = client;
    	}
    	
    	//restituisce il tipo di richiesta
    	public int getType()
    	{
    		return type;
    	}
    	
    	//restituisce il cliente associato alla richiesta
    	public IClientCallBack getClient()
    	{
    		return client;
    	}
    }
    
    // possibili operazioni
    protected static int WRITE_APPEND = 0;
    protected static int WRITE =1;
    protected static int READ = 2;

    //file dove vengono memorizzzati i descrittori dei file
	protected File descriptors;
	// elenco dei file
	protected Hashtable Files;
	// elenco delle code ( chiave primaria path del file), contiene una coda per ogni file utilizzato 
	protected Hashtable queues; 
	// Repository server
	protected DefaultRepositoryServer server; 
	
	/**
	 * 
	 * Costruttore
	 */
	public ResourceManager(DefaultRepositoryServer def ,File des) throws RemoteException
	{
		try
		{
			queues=new Hashtable();
			descriptors=des;
			server=def;
			if(descriptors.exists())
			{         // ci sono dei descrittori salvatiu su disco
					  ObjectInputStream in = new ObjectInputStream(new FileInputStream(descriptors));	
					  Files = (Hashtable)in.readObject();
					  in.close();
			}
			else 
				Files = new Hashtable();
		}catch(Exception e)
		{
			System.out.println("Errore costruzione del Resourcemanager");
		}
	}	
	
	 
	    /**
	     * 
	     * Accede in lettura ad un file
	     *
	     */
	    public void  read(String path,IClientCallBack client) throws Exception
	    {
	    	// accedo al descrittore
	    	FileDescriptor file =(FileDescriptor) Files.get(path);
	    	// carico eventuali code associate al file
	        ArrayList queue = (ArrayList )queues.get(path);
	        // a seconda dello sttao dle file mi comporto diversamente
	        switch (file.getStato())
	        {
	          case FileDescriptor.FREE:
	                   //file libero
	                   if(queue==null)
	                   {
	                   	   // se non c' una coda associata al file accedo in lettura
	                   	   IRepository host1 = server.resolve(file.getHost1());
	                   	   // avvio il thread di gestione del callback
	                       ClientThread thread = new ClientThread(client,host1.createProxyLettura(path,this,client,server.getExecutionMonitor()));
	                       // aggiungo un processo in lettura al file
	                       file.addProcessoLettura();
	                       // avvio il thread
	                       thread.start();
	                   }
	                   else
	                    {
	                      // la coda esiste
	                       if (queue.size()==0) 
	                       {
	                       	    //la coda esiste ma  vuota, accedo in lettura come sopra
							    IRepository host1 = server.resolve(file.getHost1());
								ClientThread thread = new ClientThread(client,host1.createProxyLettura(path,this,client,server.getExecutionMonitor()));
								file.addProcessoLettura();
								thread.start();
								return;
	                       }
	                        // accedo alla prima richiesta in coda
	                    	richiesta Temp = (richiesta) queue.get(0);
	                    	if ((Temp.getType()==WRITE)||(Temp.getType()==WRITE_APPEND))
	                    	      {
	                    	      	// Il primo elementon in coda  un processo di scrittura inserisco la richiesta inc oda
									  System.out.println("Operazione di lettura in coda perch  presente una in scrittura in coda");
	                    	      	  // aggiungo alla coda la richiesta
	                    	      	  queue.add(new richiesta(client,READ)); 
	                    	          // aggiorno l'elenco delle code
	                    	          queues.put(path,queue);
	                    	      } 
	                    	else
							{
								// posso accedere in lettura
								IRepository host1 = server.resolve(file.getHost1());
						        ClientThread thread = new ClientThread(client,host1.createProxyLettura(path,this,client,server.getExecutionMonitor()));
						        file.addProcessoLettura();
						        thread.start();
							}
	                    }
	               break;
	          case FileDescriptor.LOCK:
	             {   
	             	//il file  in stato di lock 
					System.out.println("Operazione di lettura in coda perch il file   lock");
	             	if (queue==null)
	             	   {
						  // la coda non esiste
						  //la creo
	             	      queue = new ArrayList();
	             	      //aggiungo una richiesta
						  queue.add(new richiesta(client,READ));
						  //la inserisco nell'elenco delle code
						  queues.put(path,queue); 
	             	   }  
	             	 else
					    queue.add(new richiesta(client,READ)); 
	             	 break;
	             }
	               
				case FileDescriptor.ZOMBIE :  
					   {
					   	  // il file  zombie comunico al cliente che non  possibile accedervi
						  client.Error(new Exception("File in fase di eliminazione"));
						  break;
					   }
	          
	        }
	    }
	    
	    
	    /**
	     * 
	     * accede in scrittura ad un file
	     *
	     */
	    public void write(String path,boolean append,IClientCallBack client) throws Exception
	    {
	    	// carico il descrittore
	        FileDescriptor file =(FileDescriptor) Files.get(path);
	        // carico l'eventuale coda
			ArrayList queue = (ArrayList )queues.get(path);
	        int type ;
	        // discrimino i due tipi di scrittura
	        if (append) type = WRITE_APPEND;
	        else
	          type= WRITE;
	        switch (file.getStato())
	        {
	        	case FileDescriptor.FREE :  
	        	  {
	        	  	// il file  libero
	        	  	if((file.getProcessiInLettura())==0)
	        	  	    {
	        	  	    	//non vi sono processi in lettura posso accedere al file
	        	  	    	System.out.println("accedo in scrittura");
	        	  	    	// cambio lo stato dle file
	        	  	    	file.setStato(FileDescriptor.LOCK);
	        	  	    	// creo le sessioni
	        	  	    	ISessioneScrittura p1 =server.resolve(file.getHost1()).createProxyScrittura(path,append,this,client,server.getExecutionMonitor());
	        	  	    	ISessioneScrittura p2 = server.resolve(file.getHost2()).createProxyScrittura(path,append,this,client,server.getExecutionMonitor());
	        	  	    	p1.setClone(p2);
							// avviola sessione
							ClientThread thread = new ClientThread(client,p1);
						    System.out.println("Thread avviato");
						    thread.start();
	        	  	    }
	        	  	else
	        	  	  // vi sono processi in lettura mi mettoin coda
	        	  	  if(queue==null)
	        	  	  {
	        	  	  	 //la coda non esiste la creo e la inserisco nell'elenco delle richieste
	        	  	  	 System.out.println("inserico l'op in coda (1) ci sono processi in lettura "+file.getProcessiInLettura());
	        	  	     queue = new ArrayList();
	        	  	     queue.add(new richiesta(client,type));
	        	  	     queues.put(path,queue);
	        	  	  }
	        	  	  else
	        	  	     {
	        	  	     	// aggiungo la richiesta in coda
	        	  	     	queue.add(new richiesta(client,type));
							System.out.println("inserico l'op in coda (1) ci sono processi in lettura"+file.processiInLettura);
	        	  	     } 
	        	  	break;
	        	  }
	        	case FileDescriptor.LOCK :
	        	{
	        		//sul file  presente un lock
					System.out.println("inserico l'op in coda perch c' un lock sul file");
					if(queue==null)
					{
						    // creo la coda inserisco la richiesta e l'aggiungo all'elenco delle code
							queue = new ArrayList();
							queue.add(new richiesta(client,type));
							queues.put(path,queue);
				 	}
				 	else
					queue.add(new richiesta(client,type)); 
	        	break;
	        	}
	        	case FileDescriptor.ZOMBIE :  
	        	     {
	        	     	// il file  in fase di elimianzione
	        	     	client.Error(new Exception("File in fase di eliminazione"));
	        	        break;
	        	     }
	        	
	        }
	       	
	    }
	    
	   
	   
	   /**
	    * 
	    * Rilascio di un file
	    * 
	    */
	   public void rilasciaFile(String path,int type) throws RemoteException
	    {
	    	System.out.println("Rilascio della risorsa "+path+"Tipo di accesso "+type);
	        // acecdo al descrittore del file
			FileDescriptor file = (FileDescriptor)Files.get(path);
			//accedo alla coda associata
			ArrayList queue= (ArrayList)queues.get(path);
			if (type==READ)
			{
				//un processo in lettura rilascia la risorsa
				//decremento il contatore dei processi in lettura associato alla risorsa
				file.removeProcessoLettura();
			}
			if ((file.getStato()==FileDescriptor.ZOMBIE)&&(file.getProcessiInLettura()==0))
			{
				System.out.println();
				// il file deve essere eliminato
				if (queue!=null) 
				{
					// comunico a tutti i clienti in coda che elimino il file
					while(queue.size()>0)
					{
						richiesta temp = (richiesta)queue.get(0);
						temp.getClient().Error(new Exception("file in fase di eliminazione"));
						queue.remove(0);
					}
				}
				// elimino fisicamente il file
				server.elimina(path,file.getHost1(),file.getHost2());
				// elimino i descrittori
				eliminazione(path);
				return;
			}
			// rilascio del file dopo un 'operazione di lettura
	    	if (type == READ)
	    	   {
	    	   	  // se la coda  vuota ritorno al chiamante
				  if (queue==null) return;
				  // la coda contiene dei processi 
	    	   	  if(file.getProcessiInLettura()==0)
	    	   	  {     // non vi sono altri processi in lettura 
	    	   	  	    if (queue.size()==0) return;
	    	   	  	    // prelevo la richiesta 
						richiesta temp = (richiesta)queue.get(0);
	    	   	  		if ((temp.getType()==WRITE)||(temp.getType()==WRITE_APPEND))
	    	   	  		{
	    	   	  			// presente un processo di scrittura lo attivo
							boolean append;
						    if (temp.getType() == WRITE_APPEND) append=true;
							else append=false;
	    	   	  			try
	    	   	  			{
	    	   	  			 // attivazione di un processo di scrittura
	    	   	  		     file.setStato(FileDescriptor.LOCK);
	    	   	  		     queue.remove(0);
	    	   	  		     IClientCallBack client = temp.getClient();
							 ISessioneScrittura p1 =server.resolve(file.getHost1()).createProxyScrittura(path,append,this,client,server.getExecutionMonitor());
							 ISessioneScrittura p2 = server.resolve(file.getHost2()).createProxyScrittura(path,append,this,client,server.getExecutionMonitor());
							 p1.setClone(p2);
							 ClientThread thread = new ClientThread(client,p1);
	    	   	  			 thread.start();
	    	   	  			}catch(Exception e) 
	    	   	  			{
	    	   	  			 e.printStackTrace();
	    	   	  			 System.out.println("errore durante la scrittura : "+e); 
	    	   	  			}
	    	   	  		}
	    	   	  	}
	    	   	  
	    	   }
	    	 else
	    	  {
				  file.setStato(FileDescriptor.FREE);
	    	  	   // Un processo in scrittura libera la risorsa
	    	  	   if (queue==null)
	    	  	   {
	    	  	   	  // la cosa  vuota libero la risorsa
	    	  	   	  return;
	    	  	   }
	    	  	   else
	    	  	   {
	    	  	   	
	    	  	   	if (queue.size()==0)
	    	  	   	 {
	    	  	   	 	System.out.println(" Coda vuota ");
				 	 	return;
	    	  	   	 }
	    	  	   	//la coda non  vuota
					richiesta temp = (richiesta)queue.get(0);
					if ((temp.getType()==WRITE)||(temp.getType()==WRITE_APPEND))
					{
						// vi sono processi in scrittura in attesa prelevo il primo
						boolean append;
						if (temp.getType() == WRITE_APPEND) append=true;
						else append=false;
						try
						{
							 file.setStato(FileDescriptor.LOCK);
							 queue.remove(0);
							 IClientCallBack client = temp.getClient();
							 ISessioneScrittura p1 =server.resolve(file.getHost1()).createProxyScrittura(path,append,this,client,server.getExecutionMonitor());
						 	 ISessioneScrittura p2 = server.resolve(file.getHost2()).createProxyScrittura(path,append,this,client,server.getExecutionMonitor());
							 p1.setClone(p2);
							 ClientThread thread = new ClientThread(client,p1);
							 thread.start();
						}catch(Exception e) 
							{
										 e.printStackTrace();
										 System.out.println("errore durante la scrittura : "+e); 
							}
					}
					else
					{
						//Vi sono processi in lettura in coda
						// li attivo tutti 
	    	  	   		while((queue.size()>0)&&(temp.getType()==READ))
						{
							file.addProcessoLettura();
							queue.remove(0);
							try
							{
						  		IClientCallBack client =temp.getClient();
						  		IRepository Host1 = server.resolve(file.getHost1());
						  		ClientThread thread = new ClientThread(client,Host1.createProxyLettura(path,this,client,server.getExecutionMonitor()));
						  		thread.start();
							}catch (Exception e)
							{
								e.printStackTrace();
								System.out.println("Errore nella lettura da parte del client "+e);
							}
							if (queue.size()>0)temp = (richiesta)queue.get(0);
						}
						
					}
					
	    	  	   }
	    	  }
	    }
	    
	    
	    /**
	     * 
	     * Aggiunge il file , crea il descrittore associato
	     *
	     */
		public boolean aggiungiFile(String path,String Host1,String Host2) throws Exception
		{
			try
			{       
				    // controllo che il file sia gi stato creato
				    FileDescriptor temp = (FileDescriptor)Files.get(path);
					if (temp!=null) return false;
					// creao il descrittore del nuovo file e loaggiungo all'elenco
					Files.put(path,new FileDescriptor(path,Host1,Host2));
					// aggiorno il file 
					FileOutputStream output = new FileOutputStream(descriptors,false);
					ObjectOutputStream out = new ObjectOutputStream(output);
					out.writeObject(Files);
					out.close();
					output.close();
				    return true;
			}catch (Exception e)
					{
						throw  new Exception("Errore durante la creazione del file",e);
					}
			
		};
		
		
		/**
		 * 
		 * Elimina il file "path"
		 *
		 */
		public void eliminaFile(String path) throws Exception
		{
			// accedo al descrittore
			FileDescriptor file  =(FileDescriptor) Files.get(path);
			if (file==null) throw new Exception("Resource Manager : File non esistente");
			if ( (file.getStato()==FileDescriptor.FREE)&&(file.getProcessiInLettura()==0) )
			{
				//  possibile eliminare il file
				server.elimina(path,file.getHost1(),file.getHost2());
				eliminazione(path);
			}
			else
			{
				// non  possibile eliminare il file
				file.setStato(FileDescriptor.ZOMBIE);
			}
		}
		
		
		/**
		 * 
		 * Eliminazione del descrittore associato ad un file
		 *
		 */
		protected void eliminazione(String path) 
		{
			// elimino il descrittore
			Files.remove(path);
			try
					{
						FileOutputStream output = new FileOutputStream(descriptors,false);
						ObjectOutputStream out = new ObjectOutputStream(output);
						out.writeObject(Files);
						out.close();
						output.close();
					}catch (Exception e)
							{
								e.printStackTrace();
							}
		}
	
	
}
