/*
 * Created on 14-lug-2004
 *
 * 
 */
package FRS;

import DFSS.*;
import java.io.*;

/**
 * @author Dario Agostinone
 *
 *    Insieme di informazioni che caratterizzabno un log
 * 
 */
public class LogInformation implements Serializable {

        // sessione che ha effettuato il log
		protected ISessione sessione;
		// istante in cui  stato effettuato il log
		protected long timeStamp;
		// cliente associato alla sessione
        protected IClientCallBack client;
        // file gestito
		protected String path;
		//tipo di sessione
		protected int SessionType;
        
        /**
         * 
         * 
         * Costruttore
         */
		public LogInformation( String logicalPath,int type,ISessione ses , long timestamp, IClientCallBack client  )
		{
			timeStamp=timestamp;
			sessione=ses;
			SessionType=type;
			path=logicalPath;
			this.client=client;
		}
		
		/**
		 * 
		 * Restituisce il path del file
		 *
		 */
		public String getFilePath()
		{
		    return path;	
		}
		
		/**
		 * 
		 * tipo della sessione
		 *
		 */
		public int getSessionType()
		{
			return SessionType;
		}
		
		
		/**
		 * 
		 * Restituisce il time stamp
		 *
		 */
		public long getTimeStamp()
		{
			return timeStamp;
		}
		
		/**
		 * 
		 * 
		 * Restituisce il cliente
		 *
		 */
		public IClientCallBack getClient()
		{
			return client;
		}
		
		/**
		 * 
		 * Resituisce la sessione
		 *
		 */
		public ISessione getSessione()
		{
			return sessione;
		}
		
		/**
		 * 
		 * converte il log in una stringa
		 */
		public String toString()
		{
			return " log - "+sessione+" - "+" at  "+timeStamp;
		}
}
