/*
 * Created on 2-lug-2004
 *
 * 
 */
package FRS;

import DFSS.*;

import java.rmi.*;

/**
 * @author Dario Agostinone
 *
 *  Interfcaccia del RepositoryServer
 * 
 */
public interface IFileRepositoryServer extends Remote {
	
	/**
	 * 
	 * Crea un file
	 *
	 */
	public boolean  creaFile( String path) throws RemoteException;
	
	/**
	 * 
	 * Rlimina un file
	 *
	 */
	public void eliminaFile(String path) throws RemoteException; 
	
	/**
	 * 
	 * Accede in lettura ad un file
	 *
	 */
	public void accediInLettura(String path,IClientCallBack cl) throws RemoteException;
	
	/**
	 * 
	 * Accede in scrittura ad un file
	 *
	 */
	public void accediInScrittura(String path,boolean append,IClientCallBack cl) throws RemoteException;

	/**
	 * 
	 * 
	 * Registra un repository
	 *
	 */
    public void registra(String rep, String address) throws RemoteException;
}
