/*
 * Created on 2-lug-2004
 *
 * 
 */
package FRS;

import java.io.*;
/**
 * @author Dario Agostinone
 *
 * Descrittore di un FILE
 * 
 */
public class FileDescriptor implements Serializable{
	
	//possibili stati del file
	public final static  int FREE=1;
	public final static int LOCK=2;
	public final static int ZOMBIE=3;
	
	//identificatore
	protected String path;
	//nome degli host dove il file  mantenuto
	protected String host1,host2;
	//stato corrente del file
	protected int stato ;
	// numero dei processi in lettura
	protected int processiInLettura ;
	
	/**
	 * 
	 * 
	 * Costruttore
	 */
	public FileDescriptor(String path, String h1,String h2)
	{
		this.path = path;
		host1 = h1;
		host2 = h2;
		processiInLettura= 0;
		stato = FileDescriptor.FREE;
	}
	
	/**
	 * 
	 * Restituisce il path
	 *
	 */
	public String getPath()
	{
		return  path;
	}
	
	/**
	 * 
	 * 
	 * Resituisce lo stato
	 *
	 */
	public int getStato()
	{
		return stato;
	}
	
	/**
	 * 
	 * 
	 * cambia lo stato dle file
	 *
	 */
	protected void setStato(int s )
	{
		stato=s;
	}
	
	/**
	 * 
	 * restituisce il numero dei processi in lettura
	 *
	 */
	protected int getProcessiInLettura()
	{
		return processiInLettura;
	}
	
	
	/**
	 * 
	 *  aggiunge un processo in lettura
	 *
	 */
	protected void addProcessoLettura()
	{
		processiInLettura++;
	}
	
	/**
	 * 
	 * 
	 * Resyituisce il nome dell'host1
	 *
	 */
	protected String getHost1()
	{
		return host1;
	}
	
	/**
	 * 
	 * Restituisce il nome dell'host2
	 *
	 */
	protected  String getHost2()
	{
		return host2;
	}
	
	/**
	 * 
	 *  rimuove un processo in lettura
	 *
	 */
	protected void removeProcessoLettura()
	{
		processiInLettura--;
	}
	
	/**
	 * 
	 * Converte il descrittore in una stringa
	 */
	public String toString()
	{
		return (" PathFile = "+path+"Stato "+stato+" processi in lettura = "+processiInLettura);
	}
}
