/*
 * Created on 14-lug-2004
 *
 * 
 */
package FRS;


import java.rmi.*;
import java.util.*;
import java.rmi.server.UnicastRemoteObject;
/**
 * @author Dario Agostinone
 *
 *  Effettua il controllo dell'esecuzione dei proxy , in questa prima versione, verifica solo se un proxy o il client 
 *  hanno avuto dei guasti e libera la risorsa
 */
public class ExecutionMonitor extends UnicastRemoteObject implements IExecutionMonitor {

        // tabella contenente i messaggi di log dei proxy
		protected Hashtable logs;
		// riferimento al resource Manager
		protected ResourceManager resManager;
		// thread che avvia dei controlli ogni CONTROL secondi
        protected ThreadMonitor thread;
        // Se un server non comunica un log entro  un TIMEOUT rispetto al precedente viene liberata la risorsa
        protected final static int TIMEOUT = 5000;
        
        // frequenza con la quale vengono effettuati i controlli
        protected final static int CONTROL =3000;
        
	    /**
	     * 
	     * Costruttore
	     */
		public ExecutionMonitor(ResourceManager res) throws RemoteException
		{
			// inizializzazione stato interno
			logs=new Hashtable();
			resManager = res;
			thread=new ThreadMonitor(this,resManager);
			thread.start();
			
		}
		
		/**
		 * 
		 * Aggiunge un log
		 */
		public void addLog(LogInformation in) throws RemoteException
		{
		    ISessione ses = in.getSessione();
		    logs.put(ses,in);	
		}
		
		/**
		 * 
		 * Restituisce l'insieme dei log ricevuti
		 *
		 */
		public Enumeration getLogs()
		{
			return logs.elements();
		}
		
		/**
		 * 
		 *  rimuove una sessione dall'elenco dei log
		 */
		public void remove(ISessione ses) throws RemoteException 
		{
			System.out.println("Elimino una sessione "+ses);
			logs.remove(ses);
		}

}
