/*
 * Created on 2-lug-2004
 *
 * 
 */
package FRS;

import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

import java.io.*;
import DFSS.IClientCallBack;
import java.util.*;

/**
 * @author Dario Agostinone
 *
 *   Repository Server
 * 
 */
public class DefaultRepositoryServer
	extends UnicastRemoteObject
	implements IFileRepositoryServer {
  
    //cartella dove vengono salvate le informazioni
	protected String home ;
	// file che contiene i nomi dei repository registrati
	protected File repository;
	//gestore delle risorse
	protected ResourceManager resourceManager;
	//elenco dei reposiotry
	protected Hashtable repositories;
	//monitor dell'esecuzione dei proxy
	protected ExecutionMonitor execMonitor;
	
	/**
	 * 
	 * Costruttore
	 */
	public DefaultRepositoryServer(String path) throws RemoteException
	{
	  try
	  {
	  home=path;	
	  resourceManager =new ResourceManager(this,new File(home+"/"+"_descriptors.dat"));
	  execMonitor = new ExecutionMonitor(resourceManager);
	  repository = new  File(home+"/"+"_repositories.dat");
	  repositories = new  Hashtable(); 
	  }catch (Exception e)
	  {
	  	throw new RemoteException("Errore creazione repository ",e);
	  }
	}
	
	/**
	 * 
	 * Restituisce l'esxecution monitor
	 *
	 */ 
	public IExecutionMonitor getExecutionMonitor()
	{
		 return execMonitor;
	}
	
	/**
	 * 
	 * Restituisce il riferimento remoto di un repository a partire dal nome
	 *
	 */ 
	public IRepository resolve(String nome)
	{
		return (IRepository)repositories.get(nome);
	}
	
	/**
	 * 
	 * Registra un repository
	 */
	public void registra(String rep , String  ipAddress)throws RemoteException
	{
        try
	    {
			IRepository  r= (IRepository)Naming.lookup("//"+ipAddress+":1099/"+rep);
			repositories.put(rep,r);
		}catch(Exception e)
		{
			throw new RemoteException("Errore durante la registrazione ",e);
		}
	}
	
	/**
	 * 
	 * Crea un file
	 */
	// in questo prototipo si auppone che ci siano sempre due repository attivi 
	public synchronized boolean creaFile(String path) throws RemoteException {
		
		try
		{
		 //viene caricato l'elenco dei repository	
		 Enumeration enum=repositories.elements();
		 //viene caricato l'elenco die nomi
		 Enumeration keys = repositories.keys();
		 // Riferimenti remoti
		 IRepository host1 =(IRepository) enum.nextElement();
		 IRepository host2 = (IRepository) enum.nextElement(); 
		 // nomi dei repository
		 String host1s = (String)keys.nextElement();
		 String host2s = (String) keys.nextElement();
		 // demanda la creazione dei descrittori dei dile al resource manager
		 boolean res = resourceManager.aggiungiFile(path,host1s,host2s);
		 if (res )
		 {
		 	//il file  stato aggiunto correttamente , lo creo sui due repository
		 	host1.createFile(path); 
		 	host2.createFile(path);
		 }	
		 notifyAll();
		 return res;
		}catch (Exception e)
		{
			notifyAll();
			throw  new RemoteException("Errore durante la creazione del file",e);
		    
		}
		
	}

	/**
	 *  Elimina il file caratterizzato dal path = path
	 * 
	 */
	public synchronized void eliminaFile(String path) throws RemoteException {
		
        try{
        	// prima viene effettuata l'eliminazione logica , l'eliminazione fisica potrebbe essere ritardata 
        	//a causa della presenza di processi che accedono al file
			resourceManager.eliminaFile(path);
			notifyAll();
		}catch( Exception e){
			notifyAll();
			throw new RemoteException("Errore durante la rimozione del file",e);
		}
	}
	
	/**
	 * eliminazione fisica del file, chiamata dal resource manager , quando  possibile eliminare fisicamente il file
	 */
	protected void elimina(String path,String Host1, String Host2)
	{
		try
		{
			//carico i repository che contengono il file
			IRepository rep1 = resolve(Host1);
			IRepository rep2 = resolve(Host2);
			//elimino il file da entrambi
			rep1.deleteFile(path);
			rep2.deleteFile(path);
		}catch(Exception e )
		{
			System.out.println(" Errore durante l'eliminazione fisica del file "+e.toString());
		}
	}

	/**
	 * 
	 * Accede in lettura ad un file
	 */
	public synchronized void accediInLettura(String path, IClientCallBack cl)
		throws RemoteException {
		try
		{
		 //la richiesta viene inoltrata al resource Manager
         resourceManager.read(path,cl);
		 notifyAll();
		}catch (Exception e)
		{
			notifyAll();
			throw new RemoteException("Repository Server : errore read file ",e);
		}
	}

	/**
	 * 
	 *  Accede in scrittura ad un file
	 * 
	 */
	public synchronized void accediInScrittura(String path,boolean append, IClientCallBack cl)
		throws RemoteException {
		try
		{
                 //la richiesta viene inoltrata al resourceManager
				 resourceManager.write(path,append,cl);
			     notifyAll();
		}catch (Exception e)
				{
					notifyAll();
					throw new RemoteException("Repository Server :errore write file ",e);
				}

	}
	
	//creazione del repository
	public static void main (String args[])
	{
		// stringa utilizzata per il binding
		String CompleteName = "//"+args[0]+":1099/FRS";
				if (System.getSecurityManager() == null)
							{	System.setSecurityManager(new RMISecurityManager()); }
				try
				{    	
							DefaultRepositoryServer server = new DefaultRepositoryServer("E:\\FDSSTEMP\\Repository");
							// registrazione presso il registry
							Naming.rebind(CompleteName, server);
							System.out.println("Server RMI: servizio registrato");     
				}
				catch (Exception e)
				{ 
								System.out.println("Server RMI: " + e.getMessage()); 
								System.exit(1);  
				}
	}

}
