/*
 * Created on 10-lug-2004
 *
 * 
 */
package DFSS;


import java.util.*;
/**
 * @author Dario Agostinone
 *
 * Gestore del vectorclock
 * 
 */
public class gestoreVectorClock {
	
	// vector clock del server
	protected Hashtable  vettore;
	// nome del server locale
	protected String localName;
	
    /**
     * 
     * Costruttore
     */
	public gestoreVectorClock(String NodeName)
	{
		//inizializzo lo stato interno
		vettore = new Hashtable();
	    vettore.put(NodeName,new Contatore());
	    localName = NodeName;
	}
	
	/**
	 * 
	 * Aggiunge una entry al vector clock
	 *
	 */
	
	public synchronized void addEntry(String NodeName)
	{
		vettore.put(NodeName,new Contatore());
		notifyAll();
	}
	
	/**
	 * 
	 * rimuove una entry
	 *
	 */
	public synchronized void removeEntry(String NodeName)
	{
		vettore.remove(NodeName);
		notifyAll();
	}
	
	
	/**
	 * 
	 * Aggiorna il vector clock locale a partire da un vector clock passato in ingresso
	 *
	 */
	public synchronized void aggiorna( Hashtable vectorClock)
	{
		// scandisco tutti i nomi conosciuti
		Enumeration vet = vettore.keys();
		while(vet.hasMoreElements())
		{
			String temp = (String)vet.nextElement();
			Contatore contloc = (Contatore)vettore.get(temp);
			Contatore contrem = (Contatore)vectorClock.get(temp);
			if (contrem!=null)
			    contloc.set(Math.max(contloc.getValue(),contrem.getValue()));
		} 
		notifyAll();
	}
	
	/**
	 * 
	 * converte il valore del vector clock in una stringa
	 *
	 */
	public  String toString()
		{
			String out = "Vector Clock ";
			Enumeration enum = vettore.keys();
					while(enum.hasMoreElements())
					   {
						String key = (String )enum.nextElement();
						out=out+"\n"+key+"->"+(vettore.get(key).toString());
					   }
		   return out;
		}
	
	/**
	 * 
	 * Determina il minore tra due vector clock
	 *
	 */
	public static boolean isLess(Hashtable vect1, Hashtable vect2)
	{
		        // accedo al primo vettore
		        Enumeration vet = vect1.keys();
		        boolean flag = false;
				while(vet.hasMoreElements())
				{
					String temp = (String)vet.nextElement();
					Contatore contloc = (Contatore)vect1.get(temp);
					Contatore contrem = (Contatore)vect2.get(temp);
					if (contrem!=null)
						{
							if (contloc.getValue()>contrem.getValue()) return false;
							else
							  {
							  	if (contloc.getValue()<contrem.getValue()) flag=true;
							  } 
						} 
				} 
				return flag;
		
	}
	
	/**
	 * 
	 *   restituisce il vector clock 
	 *
	 */
	public  Hashtable getVectorClock()
	{
		
		return vettore;
	}
	
	/**
	 * 
	 * Aggiornamento del vector clock a fronte di un evento interno
	 *
	 */
	public synchronized void event()
	{
		Contatore cont = (Contatore)vettore.get(localName);
		cont.incrementa();
		notifyAll();
	}
	
	

}
