/*
 * Created on 11-lug-2004
 *
 * 
 */
package DFSS;

/**
 * @author Dario Agostinone
 *
 *    Thread che gestisce l'apprendimento di un nuovo server
 * 
 */
public class ThreadApprendimento extends Thread 
{
	// datamanager locale
	protected Datamanager datamanager;
	// server che deve effettuare l'apprendimento
	protected IDistributedFileSystemServiceManager serv;
	// group manager
	protected IGroupManager group;
	
	/**
	 * 
	 * 
	 * Costruttore
	 */
	public ThreadApprendimento( Datamanager data,IGroupManager group,IDistributedFileSystemServiceManager serv )
	{
	   datamanager = data;
	   this.group=group;
	   this.serv=serv;
	}
	
	/**
	 * 
	 * Metodo run
	 */
	public void run()
	{
	  try
	  {
	  	// carica le informazioni del file system locale
		Directory root = datamanager.getDirectory("ALL");
		// accedo ai nodi appartenenti al gruppo
		HostID[] hosts = group.getGroup();
		// avvio dell'apprendimento
	    serv.apprendi(root,hosts);
	  }catch(Exception e)
	  {
	  	System.out.println(" Errore durante l'apprendimento "+e);
	  }
	}
	

}
