/*
 * Created on 6-lug-2004
 *
 * 
 */
package DFSS;

/**
 * @author Dario Agostinone
 *
 *   Gestore dei messaggi 
 * 
 */

import java.rmi.*;


public class MessageManager implements IQueueListener {
    
    // group manager	
	protected IGroupManager group;
	// coda die messaggi associata
	protected IQueueManager messageQueue;
	//data manager
	protected Datamanager data;
	//nome del nodo locale
	protected HostID NodeName;
	// gestore del vector clock
	protected gestoreVectorClock gestore;
	
	/**
	 * 
	 * Costruttore
	 */
	public MessageManager(HostID myID,gestoreVectorClock vector ,IGroupManager group , IQueueManager messageQueue, Datamanager Data )
	{
		// inizializzazione
		this.group = group;
		this.messageQueue =messageQueue;
		this.data=Data;
		this.NodeName=myID;
		this.gestore =vector;
	}
	
	/**
	 *  metodo chiamato , quando viene inserito un messaggio in coda
	 * 
	 */
	public void insertElement()
	{
		decodeMessage((Message)messageQueue.getNext());
	}
	
	
	/**
	 * 
	 *  decodifica il messaggio ricevuti
	 *
	 */
	public void decodeMessage(Message in)
	{
		// accedo al corpo del messaggio
		String temp[]=in.getCorpo();	
		// aggiorno il vector clock locale
		gestore.aggiorna(in.getVectorClock());
		// aggiorno il vector a fronte di un evento
		gestore.event();
		switch (in.getOggetto())
			{
				case Message.NEWNODE :
				      {
				      	//inseirmento di un nuovo nodo
						try
						{
				      	    // accedo al riferimento remoto del server
				            IDistributedFileSystemServiceManager serv =(IDistributedFileSystemServiceManager) Naming.lookup("//"+temp[1]+":1099/"+temp[0]); 
				            // aggiungo una entry nel vector clock
				            gestore.addEntry(temp[0]);
				            // aggiungo il nodo al gruppo
				            group.addNodo(new HostID(temp[0],temp[1]),serv);  	 
				          }catch (Exception e)
				          {
				          	System.out.println(" Errore durante l'aggiunta del nuovo nodo"+e.toString());
				          }
				      	 break;
				      }
				case Message.NEWDIR :
				     {
				     	// creazione di una nuova cartella
				     	try
				     	{
				     	// creo la cartella
				     	Directory newDir =new Directory(temp[0]);
				     	// slavo la cartella
				     	data.saveDirectory(newDir);
				     	break;
				     	}catch(Exception e)
				     		{
								System.out.println(" Errore durante l'aggiunta di una cartella"+e.toString());	
				     		}
				     }
				case Message.NEWFILE:
				    {
				    	// aggiungo un nuovo file
				    	try
				    	{
				     		data.addFile(temp[0],temp[1],temp[2]);
							break;
				    	}catch(Exception e)
				    	{
							System.out.println(" Errore durante l'aggiunta di una cartella"+e.toString());	
				    	}
				     }
				case Message.REMOVEDIR :
				   {
				   	    // rimuovo una cartella
				   	    data.removeDirectory(temp[0]);
				   	    break;
				   }
				case Message.REMOVEFILE :
				{
					// rimuovo un file
					try
					{
					data.rimuoviFile(temp[0],temp[1]);
					break;
					}catch(Exception e)
					{
						System.out.println(" Errore durante la rimozione di un file"+e.toString());	
					}
				}
			}
	}
	
	/**
	 * 
	 * propaga l'inseirmento di un nodo
	 *
	 */
	public void insertNode(HostID in)
	{
		String [] corpo = new String[2];
		corpo[0]=in.getNome();
		corpo[1]=in.getIP();
		gestore.event();
		Message  temp = new Message(Message.NEWNODE,corpo,NodeName,gestore.getVectorClock());
	    group.sendMulticastMessage(temp);
	}
	
	/**
	 * 
	 * propaga la creazione di una directory 
	 *
	 */
	public void newDirectory(String name)
	{
		String [] corpo = new String[1];
		corpo[0]=name;
		gestore.event();
		Message  temp = new Message(Message.NEWDIR,corpo,NodeName,gestore.getVectorClock());
		group.sendMulticastMessage(temp);
	}
	
	/**
	 * 
	 *  propaga la rimozione di una directory
	 *
	 */
	public void removeDirectory(String name)
		{
			String [] corpo = new String[1];
			corpo[0]=name;
			gestore.event();
			Message  temp = new Message(Message.REMOVEDIR,corpo,NodeName,gestore.getVectorClock());
			group.sendMulticastMessage(temp);
		}
	
	/**
	 * 
	 *  propaga la creazione di un nuovo file
	 *
	 */
	
	public void newFile(String Directory,String name,String path)
	{
		String [] corpo = new String[3];
		corpo[0]=Directory;
		corpo[1]=name;
		corpo[2]=path;
		gestore.event();
		Message  temp = new Message(Message.NEWFILE,corpo,NodeName,gestore.getVectorClock());
		group.sendMulticastMessage(temp);
	}
	
	/**
	 * 
	 * propaga la rimozione di un file
	 *
	 */
	public void removeFile(String Directory , String name)
	{
		String [] corpo = new String[2];
		corpo[0]=Directory;
		corpo[1]=name;
		gestore.event();
		Message temp = new Message(Message.REMOVEFILE,corpo,NodeName,gestore.getVectorClock());
		group.sendMulticastMessage(temp);
	}
}
