/*
 * Created on 29-giu-2004
 *
 * 
 */
package DFSS;

import java.io.*;
import java.util.*;
/**
 * @author Dario Agostinone
 *
 *  Classe che rappresenta un messaggio
 * 
 */


public class Message implements Serializable,Ordinable{
    
    public static final int NEWNODE=0;
    public static final int NEWDIR =1;
    public static final int NEWFILE =2;
    public static final int REMOVEFILE=3;
    public static final int REMOVEDIR =4;
    public static final int REMOVENODE =5;

    // tipo di messaggio
	protected int m_oggetto ;
	// informazioni contenuti nel messaggio
	protected String[] m_corpo;
	// host mittente
	protected HostID m_mitname;
	// time stamp
	protected Hashtable m_VectorClock;
	
	/**
	 * 
	 * Costruttore
	 */
	public Message(int oggetto,String[] corpo,HostID Mittente,Hashtable vectorClock)
	{
		//inizializzazione stato interno
		m_oggetto=oggetto;
		m_corpo = corpo;
		m_mitname=Mittente;
		m_VectorClock = vectorClock;
	}
	
	/**
	 * 
	 * resituisce il tipo del messaggio
	 *
	 */
	public int getOggetto()
	{
		return m_oggetto;
	}
	
	/**
	 * 
	 * restituisce il corpo del messaggio
	 *
	 */
	public String[] getCorpo()
	{
		return m_corpo;
	}
	
	/**
	 * 
	 * restituisce il mittente del messaggio
	 *
	 */
	public HostID getMittente()
	{
		return m_mitname;
	}
	
	/**
	 * 
	 * restituisce il time stamp
	 *
	 */
	public Hashtable  getVectorClock()
	{
		return m_VectorClock;
	}
    
    /**
     * 
     * resituisce true se il messaggio  minore dell'oggetto in ingresso
     */
    public boolean isLess(Object in)
    {
    	return gestoreVectorClock.isLess(this.getVectorClock(),((Message)in).getVectorClock());
    }
}
