/*
 * Created on 2-giu-2004
 *
 * 
 * 
 */
package DFSS;

import java.io.Serializable;
import java.util.*;
/**
 * @author Dario Agostinone
 *
 * Mantiene le informazioni logiche associate ad una cartella
 * 
 */
public class Directory implements Serializable {
	
	//path della cartella
	protected String path;
	//elenco dei file
    protected Hashtable files;
    //sotto cartelle
    protected Hashtable directories;
    
    /**
     * 
     * Costruttore
     */
    
    public Directory(String path)
    {
    	this.path=path;
       	files=new Hashtable();	
       	directories = new Hashtable();
    }
    
    /**
     * 
     * resituisce il path della cartella
     *
     */  
    public String getPath()
    {
       	return path;
    }
    
    /**
     * 
     * Aggiunge una directory alla directory corrente
     *
     */
    public void addDirectory( Directory dir)
    {
    	directories.put(dir.getPath(),dir);
    }
    
    /**
     *  rimuove una sotto directory
     *
     */
    public void removeDirectory(String path)
    {
    	directories.remove(path);
    }
    
    /**
     * 
     * Rstituisce l'insieme delle sotto directory
     *
     */
    public Enumeration getSottoDirectory()
    {
    	return directories.elements();
    }
    
    /**
     * 
     *  restituisce la sotto directory caratterizzata dal path =path
     *
     */
    public Directory getDirectory(String path)
    {
    	return (Directory)directories.get(path);
    }
    
    /**
     * 
     * Aggiunge il file alla cartella
     *
     */
    public void addFile(String in,int id )
    {
    	files.put(in,new Integer(id));
    }
    
    /**
     * 
     * restituisce l'insieme dei file contenuti nella cartella
     *
     */
    
    public Enumeration getFiles()
    {
    	return files.keys();
    }
    
    /**
     * 
     * restituisce l'insieme degli identificatori dei file
     *
     */
    public Enumeration getIDs()
    {
    	return files.elements();
    }
    
    /**
     * 
     * restituisce il l'id del file path
     *
     */
    public String getFileId(String path)
    {
    	return (String)files.get(path);
    }
    
}
