/*
 * Created on 15-giu-2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package DFSS;

import java.util.*;

/**
 * @author Dario Agostinone
 *
 *  Gestisce una coda seconda una politica FIFO, oppure ordinata seconda la politica definita dagli elementi appartenenti alla coda
 * 
 */
public class DefaultQueueManager implements IQueueManager {

   //elementi appartenenti alla coda
   protected ArrayList elements ;
   //listener della coda
   protected ArrayList listener;
   //ordered = false -> politica FIFO
   protected boolean ordered;
   
   /**
    * 
    * Costruttore
    */
   public DefaultQueueManager()
   {
   	 // inizializzo lo stato interno della coda
   	 listener=new ArrayList();
   	 elements=new ArrayList();
   	 ordered=false;
   }
   /**
    * 
    * Costruttore
    */
   public DefaultQueueManager(boolean Ordered )
   {
	//	inizializzo lo stato interno della coda
   	ordered = Ordered;
	listener=new ArrayList();
	elements=new ArrayList();
   }
   
   
   /**
    * aggiunge un listener alla coda
    */
   
   public void addListener(IQueueListener queueList)
   {
   		listener.add(queueList);
   }
   

    /**
     * inserimento ordinato 
     *
     */
    	
	private void orderedInsert(Ordinable in)
	{
		if (elements.size()==0) 
			{
				// la coda  vuota
				elements.add(in);
			}
		else
		{
			// effettuo l'inserimento nella posizione appropriata
			Ordinable obj = (Ordinable)elements.get(0);
			int i =0;
			while(obj.isLess(in))
			{
				i=i+1;
				obj = (Ordinable)elements.get(i);
			}
			elements.add(i,in);
		}
	}
	
	/**
	 * inserisce un elemento nella coda
	 */
	public void insert(Object in)
	{
		elements.add(in);
		InsertThread event = new InsertThread(listener); 
		event.start();
	}
	
	/**
	 * 
	 * inserisce un elemento ordinabile nella lista
	 *
	 */ 
	public synchronized void insert(Ordinable in) 
	{
		if (!ordered)
		{
			// politica FIFO
			elements.add(in);
		}
		else
		{  
			// coda ordinata
			orderedInsert( in ); 
		} 
		// notifico ai listener l'avvenuto inserimento
		InsertThread event = new InsertThread(listener); 
		event.start();
		notifyAll();
	}
    
    /**
     * 
     * resituisce true se la coda ha delgi elementi
     */
    
	public boolean hasMoreElement()
	{
		if (elements.size()!=0) return true;
		else return false;
	}
	
	/**
	 * 
	 * preleva un elemento dalla coda eliminandolo
	 * 
	 */
	synchronized public Object getNext() {
		if (elements.size()==0) return null;
		Object op = elements.get(0);
		elements.remove(0);
		notifyAll();
		return op;
	}

}
