/*
 * Created on 29-giu-2004
 *
 * 
 */
package DFSS;


import java.util.*;
/**
 * @author Dario Agostinone
 *
 * Gestore del gruppo di service manager
 * 
 */


public class DefaultGroupManager implements IGroupManager {

    // hash table che contiene i nodi conosciuti
	protected Hashtable snodi; 
    
    /**
     * 
     * Costruttore
     */
    public DefaultGroupManager()
    {
    	snodi=new Hashtable();
    	
    }
    
	/* 
	 * Invia un messaggionin multicast
	 *   
	**/
	public void sendMulticastMessage(Message in) {
		// accedo alla lita dei destinatari
		IDistributedFileSystemServiceManager[] destinatari = new IDistributedFileSystemServiceManager[snodi.size()];
		Enumeration enum = snodi.elements();
		int i=0;
		while(enum.hasMoreElements())
		{
			destinatari[i]=(IDistributedFileSystemServiceManager)enum.nextElement();
		    i=i+1;
		}
	    // creo un thread che si occupera dell'invio dei messaggi
	    Postino postino = new Postino(in,destinatari);
		postino.start();
	}

	/** 
	 * Invia un messaggio al destinatario all'HostID passato in ingresso
	 */
	public void sendMessage(Message in, HostID destname) {
		IDistributedFileSystemServiceManager dest[] = new IDistributedFileSystemServiceManager[1];
		dest[0] =(IDistributedFileSystemServiceManager) snodi.get(destname);
		Postino postino = new Postino(in,dest);
		postino.start();
	}

	/**
	 * Aggiunge un nodo al gruppo
	 */
	public void addNodo(HostID host,IDistributedFileSystemServiceManager serv) {
		snodi.put(host,serv);
	}
 
 	/**
 	 * restituisce l'insieme degli hostID dei nodi appartenenti al gruppo
 	 */
	public HostID[] getGroup()
	{ 
		HostID[] gruppo = new HostID[snodi.size()];
	    Enumeration enum = snodi.keys();
	    int i=0;
	    while(enum.hasMoreElements())
	    {
		 gruppo[i]=(HostID)enum.nextElement();
		 i=i+1;
	    }
		return gruppo;
	}
}
