/*
 * Created on 3-giu-2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package DFSS;

import java.io.*;
import java.util.*;

/**
 * @author Dario Agostinone
 *
 *  Classe che gestisce la memorizzazione relativa alle cartelle del file system
 * 
 *  tramite il comando getDirectory("ALL")  possibile accedere all'intero contenuto del file system
 */
public class Datamanager implements Serializable {
	
	/**
	 * Cartella home in cui vengono memorizzate le informazioni
	 */
	protected String home;
	
	public  Datamanager(String home) 
	{
		this.home=home+"/ROOT";
		File dir = new File(this.home);
		if (!dir.exists()) dir.mkdir(); 
	}
	
	/**
	 * 
	 * Azzera la conoscenza del server
	 *
	 */
	protected void reset()
	{
		File dir = new File(this.home);
		File[] contents = dir.listFiles();
		for (int i=0;i<contents.length;i++)
		{
					
				if (contents[i].isDirectory())
					{
									//elimino le sotto directory
						removeDirectory(home+"/"+contents[i].getName());
					}
				else
					{
						//Elimino il file "files.dat",  l'unico file presente 
		    			contents[i].delete();
					}
		}
					//elimino la cartella
		dir.delete(); 
	}
	
	
	/**
	 * 
	 * restituisce true se la cartella caratterizzata dal path = "path"  presente nel file system
	 *
	 */
	public boolean ExistsDir(String path)
	{
		if (path.equals("ALL")) return true;
		File dir = new File(home+"/"+path);
		return dir.exists();
	}
	
	/**
	 * 
	 * Resituisce true se il file "/path/name"  presente nel file system
	 *  
	 */
	public boolean ExistsFile(String  path,String name)
	{
		try{
			    // accedo all'hash table contenente i file della cartella
				File savefiles = new File(home+path+"/"+"files.dat");
				Hashtable files;
				if (savefiles.exists())
				{
					// l'hash table  stata creata precedentemente accedo
					ObjectInputStream input = new ObjectInputStream(new FileInputStream(savefiles));	
					files  = (Hashtable)input.readObject();
					input.close();
				}
				else
				{
					// non  presente nessuna hash table: la directory  vuota
					return false;
				}
				// verifico se il file  presente nell'hashtable
				String id =(String)files.get(name);
				if (id!=null) return true;
				else return false;
				}catch(Exception e)
				{
				    return false;
				}
				
	}

    // Accede alla directory caratterizzata dal path = "ALL"
    public Directory getDirectory(String path) throws Exception
	{
		// classe che conterr la cartella fisica
		File in;
		if (path.equals("ALL"))
		{
		   // voglio accedere all'intero contenuto
		   in = new File(home);
		   path="";
		}
		else
		    // carico la directory richiesta
		    in  = new File(home.concat(path));
        // verifico l'eseistenza della cartella	
		// creo la directory Logica 
		Directory dir ;
		if (!in.exists()) return null;
		dir = new Directory(path);
		// accedo al contenuto della cartella
		File[] contents = in.listFiles();
		for (int i=0;i<contents.length;i++)
		{
			//acceddo alle sotto cartelle
			if (contents[i].isDirectory())
			{
				Directory temp = getDirectory(path+"/"+contents[i].getName());
				dir.addDirectory(temp);
			}
		}
		// accedo ai file contenuti 
		File savefiles = new File(home+path+"/"+"files.dat");
		Hashtable files=null;
		if (savefiles.exists())
		{
			// la directory contiene dei file
			   try
			   { 
			   	// carico l'elenco dei file
			    ObjectInputStream input = new ObjectInputStream(new FileInputStream(savefiles));	
				files  = (Hashtable)input.readObject();
				input.close();
			   }catch (Exception e)
			   {
			   	 throw new Exception(" Datamanager : Errore nell'accesso alla cartella "+path+" "+e.toString());
			   }
		}
		else
		 // non vi sono file creo un elenco vuoto
		 files=new Hashtable();
		dir.files=files;
		return dir;
	}

	/**
	 * 
	 * Effettua il salvataggio della cartella passata in ingresso
	 *
	 */
	
	public void  saveDirectory(Directory in) throws Exception 
	{
	 try
	 {
	 	// genero il path fisico
		String temp = home.concat(in.getPath());
		//controllo se la cartella era gi stata salvata creando eventualmente cartelle parent non esistenti
		File dir  = new File(temp); 
	    if ( !dir.exists()) dir.mkdirs();
	    // salvo le sottocartelle
	    Enumeration dirs = in.getSottoDirectory();
	    while(dirs.hasMoreElements())
	    {
	    	saveDirectory((Directory)dirs.nextElement());
	    }
	    // salvo la lista dei file se esiste
	    if (in.files!=null)
	    {
	    	ObjectOutputStream  output = new ObjectOutputStream(new FileOutputStream(home+"/"+in.getPath()+"/"+"files.dat",false));
	    	output.writeObject(in.files);
	    	output.close();
	    }
	 }catch(Exception e)
	 {
	 	throw new Exception(" Datamanager : Errore nel salvataggio della cartella "+in+" "+e.toString());
	 }
	}
	
	/**
	 * 
	 * Rimuove la cartella caratterizzata dal path="path"
	 *
	 */
	public void removeDirectory(String path)
		{
		File dir = new File(home.concat(path));
	    // se la cartella esiste la elimino insieme alle sotto cartelle
		if (dir.exists())
		{
			//accedo al contenuto della cartella fisica
			File[] contents = dir.listFiles();
			for (int i=0;i<contents.length;i++)
					{
						
						if (contents[i].isDirectory())
						{
							//elimino le sotto directory
							removeDirectory(path+"/"+contents[i].getName());
						}
						else
						{
							//Elimino il file "files.dat",  l'unico file presente 
							contents[i].delete();
						}
					}
			//elimino la cartella
			dir.delete(); 
		}
	}

    /**
     * 
     * aggiunge un file alla cartella DirectoryPath , la stringa path rappresenta l'identificatore univoco di un file utilizzato nel prototipo
     *
     */
    public void addFile(String DirectoryPath,String Filename,String path ) throws Exception
    {
    	try{
		File savefiles = new File(home+DirectoryPath+"/"+"files.dat");
		Hashtable files;
		//accedo all'elenco dei file contenuti nella cartella, se non  presente viene creato
		if (savefiles.exists())
		{
			ObjectInputStream input = new ObjectInputStream(new FileInputStream(savefiles));	
			files  = (Hashtable)input.readObject();
			input.close();
		}
		else
		{
			files = new Hashtable();
		}
		// aggiungo il nuovo file
		files.put(Filename,path);
		// salvo l'elelenco
		ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(savefiles,false));
		out.writeObject(files);
		out.close();
    	}catch(Exception e)
    	    {
    		  throw new Exception(" Datamanager : Errore nell'aggiunta del file "+path+" "+e.toString());	
    		}
    }
    
    //permette di acedere direttamente all'id di un file, restituisce null se il file non esiste
    public String getIdFile( String dir,String file ) throws Exception
    {
    	try
    	{
			File savefiles = new File(home+dir+"/"+"files.dat");
			Hashtable files =null;
			// accedo all'elenco dei file
			if (savefiles.exists())
			{
					ObjectInputStream input = new ObjectInputStream(new FileInputStream(savefiles));	
					files  = (Hashtable)input.readObject();
					input.close();
				    return (String)files.get(file);
			}
			// il file non esiste
			return null ;
    	}
    	catch(Exception e)
    	{
    	   throw new Exception(" Datamanager : errore nella lettura dell'id del file ");
    	}
    }
    
    
    /**
     * 
     * Rimuove un file dalla cartella Directory
     *
     */
    public void rimuoviFile(String Directory,String file) throws Exception 
    {
		try{
			    // Accedo all'elenco dei file
				File savefiles = new File(home+Directory+"/"+"files.dat");
				Hashtable files;
				if (savefiles.exists())
				{
					// carico la hash table
					ObjectInputStream input = new ObjectInputStream(new FileInputStream(savefiles));	
					files  = (Hashtable)input.readObject();
					input.close();
					//elimino il file richiesto
					files.remove(file);
					ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(savefiles,false));
					out.writeObject(files);
					out.close();
				}
				// il file non esiste
				}catch(Exception e)
				     {
				     	throw new Exception("Datamanager : errore durante l'eliminazione del file "+e.toString());
				      }
			
    }
}
