/*
 * Created on 6-giu-2004
 *
 * 
 */
package DFSS;

import FRS.*;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import Operations.*;



/**
 * @author Dario Agostinone
 *
 * Implementazione di un serviceManager
 * 
 */

public class DFSSserviceManager
	extends UnicastRemoteObject
	implements IDistributedFileSystemServiceManager{
        
        // ha valore true se il server pu ricevere richieste
        protected boolean ready;
        // riferimento al repository server
		protected IFileRepositoryServer repository;
		protected IQueueManager queue;
		protected IQueueManager msgQueue;
		protected CallManager call;
		protected Datamanager data;
		protected IGroupManager group;
		protected MessageManager msgManager; 
		// id del nodo
	    protected HostID myID;
	    // gestore del vector clock
	    protected gestoreVectorClock gesVectorClock; 
	
	/**
	 * Costruttore
	 */
	public DFSSserviceManager(HostID myID,IQueueManager queue,IQueueManager msgQueue, CallManager call, Datamanager data,IGroupManager group,IFileRepositoryServer rep,boolean ready ) throws RemoteException {
		//inizializzazione dello stato interno
		super();
		this.repository = rep;
		this.queue=queue;
		this.myID=myID;
		this.msgQueue = msgQueue;
		this.ready=ready;
		this.call=call;
		this.group=group;
		this.data=data;
		gesVectorClock= new gestoreVectorClock(myID.getNome());
		msgManager = new MessageManager(this.myID,gesVectorClock,group,msgQueue,data);
		msgQueue.addListener(msgManager);
	}
	 
	 /**
	  * Metodo che permette la ricezione di un messaggio
	  */
	 public boolean receiveMessage(Message in) throws RemoteException
	 {
	 	msgQueue.insert(in);
	 	return true;
	 }
	 
	 /**
	  * 
	  * Permette di aggiungere un nuovo nodo
	  *
	  */
	 public void aggiungiNodo(HostID in) throws RemoteException
	 {
	 	try
	 	{ 	
	 		// carico il riferimento remoto dell'ID inserito	
			IDistributedFileSystemServiceManager serv =(IDistributedFileSystemServiceManager) Naming.lookup("//"+in.getIP()+":1099/"+in.getNome()); 
			// aggiungo il nodo al gruppo
			group.addNodo(in,serv);
			// avverto tutti i server
			msgManager.insertNode(in);
			// aggiungo una entry nel vectir clock
			gesVectorClock.addEntry(in.getNome());
			// avvio l'apprendimento
			ThreadApprendimento thread = new ThreadApprendimento(data,group,serv);
			thread.start();  
		 } catch (Exception e)
	 	{
			throw new RemoteException("Errore durante l'aggiunta di un nuovo Service Manager ",e);
	 	}
	 }
	 
	 public void apprendi(Directory root,HostID[] hosts) throws RemoteException
	 {
		try	
		{
	 	  // aggiungo gli host presenti nel gruppo
	 	  for(int i = 0; i<hosts.length;i++)
	 	  {
	 	   	if (!hosts[i].equals(myID))
	 	   	{
	 	   		// aggiungo nel gruppo e creo una entry nel vector clock
			    IDistributedFileSystemServiceManager serv =(IDistributedFileSystemServiceManager) Naming.lookup("//"+hosts[i].getIP()+":1099/"+hosts[i].getNome()); 
	 	  	    group.addNodo(hosts[i],serv);
	 	   	    gesVectorClock.addEntry(hosts[i].getNome());
	 	   	}
	 	  }	
	 	  // azzero la conoscenza
	 	  data.reset();
          //salvo l'intero file system localmente
		  data.saveDirectory(root);
	 	  ready=true;
		}catch (Exception e)
					   {
						throw new RemoteException("Errore durante l'apprendimento "+e.toString());
					   }
	 }
	
	/**
	 * Accede al contenuto della cartella path
	 */ 		  
    public void getDirectory(String path,IClientCallBack client) throws RemoteException
    {
        if (ready==false) throw new RemoteException("Server in fase di inizializzazione ");	
    	DFSSGetDirectory op = new DFSSGetDirectory(path,client,data);
    	// valido l'operazione
    	if (!op.valida()) 
    	{
    		throw new RemoteException("Directory non esistente"); 
    	}
    	System.out.println("Richiesta operazione di get ");
        //inserimento dell'operazione in coda
        queue.insert(op);
        // aggiorni il vector clock
		gesVectorClock.event();
    }
	
	/**
	 * 
	 * Creo la cartella path
	 */
	public void createDirectory(String path,IClientCallBack cl) throws RemoteException {
		if (ready==false) throw new RemoteException("Server in fase di inizializzazione ");
		// creo l'operazione
        DFSSCreaDirectory op = new DFSSCreaDirectory(path,cl,msgManager,data);
		if (!op.valida()) 
				{
					throw new RemoteException("Directory gi esistente"); 
				}
		//inserisco l'operazione in coda
        queue.insert(op);
        //aggiorno il vectorclock
		gesVectorClock.event();
	}

	/**
	 * 
	 *  Rimuove la directory path
	 * 
	 */
	public void rimuoviDirectory(String path,IClientCallBack cl) throws RemoteException {
		if (ready==false) throw new RemoteException("Server in fase di inizializzazione ");
		// creo l'operazione
        DFSSEliminaDirectory op = new DFSSEliminaDirectory(path,cl,msgManager,repository,data);
		//valido l'operazione
		if (!op.valida()) 
				{
					throw new RemoteException("Directory non esistente"); 
				}
		//inserisco l'operazione in scrittura
        queue.insert(op);
        //aggiorno il vector clock
		gesVectorClock.event();
	}

	/**
	 * 
	 * Permette di avere acceso in lettura al file path
	 * 
	 */
	public void leggiFile(String path,IClientCallBack cl) throws RemoteException 
	{
		if (ready==false) throw new RemoteException("Server in fase di inizializzazione ");	
		System.out.println("Ricevo la richiesta diaccesso al file "+path+"\n");
		// creo l'operazione
		DFSSLeggiFile op = new DFSSLeggiFile(path,cl,repository,data);
		//valido l'operazione
		if (!op.valida()) 
				{
					throw new RemoteException("File non esistente"); 
				}
		// aggiungo l'operazione in coda
		queue.insert(op);	
		gesVectorClock.event();
	}

	/**
	 *  permette di avere un acceso in scrittura al file path
	 */
	public void scriviFile(String path,boolean append,IClientCallBack cl) throws RemoteException 
	{
		if (ready==false) throw new RemoteException("Server in fase di inizializzazione ");	
		// creo l'operazione
		DFSSscriviFile op = new DFSSscriviFile(path,append,cl,repository,data);
		//valido l'operazione
		if (!op.valida()) 
				{
					throw new RemoteException("file non esistente "+path); 
				}
		System.out.println("Ricevo la richiesta di scrittura sul file "+path+"\n");
	    // inserisco l'operazione in coda
	    queue.insert(op);
	    //restituisco il vector clock
		gesVectorClock.event();
	}
	
	/**
	 * 
	 * Crea il file path
	 * 
	 */
	public void creaFile(String path, IClientCallBack cl) throws RemoteException
	{
		if (ready==false) throw new RemoteException("Server in fase di inizializzazione ");	
		// creo l'operazione
		DFSSCreaFile op = new DFSSCreaFile(repository,path,cl,msgManager,data);
		// valido l'operazione
		if (!op.valida()) 
				{
					throw new RemoteException("File gi esistente"); 
				}
		System.out.print("Ricevo la richiesta di creazione del file "+path+"\n");
		// inserisco l'operazione in coda
		queue.insert(op);
		// aggiorno il vector clock
		gesVectorClock.event();
	}
	
	/**
	 * 
	 * Elimina il file path
	 */
	public void rimuoviFile(String path,IClientCallBack cl) throws RemoteException
	{
		if (ready==false) throw new RemoteException("Server in fase di inizializzazione ");	
		//creo l'operazione
		DFSSRimuoviFile op = new DFSSRimuoviFile(repository,path,cl,msgManager,data);
		// valido l'operazione
		if (!op.valida()) 
				{
					throw new RemoteException("File non esistente"); 
				}
		System.out.println("Ricevo la richiesta di creazione del file "+path+"\n");
		// aggiungo l'operazione in coda
		queue.insert(op);
		//aggiorno il vectorclock
		gesVectorClock.event();
	}
	
	// avvio del server
	public static void main(String args[])
	{
		boolean only = true;
		if (args.length==6)
		    {
		     // il server deve aggangiarsi ad un server prestabilit
		     only=false; 	
		    }
		// stringa di binding
		String CompleteName = "//"+args[1]+":1099/"+args[0];
		if (System.getSecurityManager() == null)
					{	System.setSecurityManager(new RMISecurityManager()); }
		try
		{    	
                    // creo i componenti del server
				    DefaultQueueManager queue = new DefaultQueueManager(); 
				    DefaultQueueManager msgQueue = new DefaultQueueManager(true);
				    CallManager call = new CallManager(queue);
				    Datamanager data = new Datamanager(args[2]);
				    DefaultGroupManager group = new DefaultGroupManager();
				    queue.addListener(call);
				    // prelevo il riferimento remoto del repository server
					IFileRepositoryServer rep =(IFileRepositoryServer ) Naming.lookup("//"+args[3]+":1099/FRS");
					DFSSserviceManager server = new DFSSserviceManager(new HostID(args[0],args[1]),queue,msgQueue,call,data,group,rep,only);
				    Naming.rebind(CompleteName, server);
				    if (!only)
				    {
				    	// effettuo la registrazione presso il nodo
				        String regServer = "//"+args[5]+":1099/"+args[4];
						System.out.println("Mi iscrivo presso il nodo "+regServer);
				        // accedo al server remoto
				        IDistributedFileSystemServiceManager reg = (IDistributedFileSystemServiceManager) Naming.lookup(regServer);
				        // aggiungo localmente il nodo dove ho effettuato la connessione
				        server.aggiungiNodo(new HostID(args[4],args[5]));
				        // effettuo la registrazione
				        reg.aggiungiNodo(new HostID(args[0],args[1]));
				    }
				   System.out.println("Sevrizio attivo");
				}
				catch (Exception e)
					{ 
						System.err.println("Server RMI: " + e.getMessage()); 
						System.exit(1);  
					}
				}


}
