﻿using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;

namespace Esempio2
{
    class Program
    {
        static void Main(string[] args)
        {
            Step1();
            //Step2();
            //Step3();
            //Step4();
            //Step4B();
            //Step5();
            //Step6();
            //Step7();
            //Step8A();
            //Step8B();
            //Step8C();
            Console.ReadLine();
        }

        private static void Step1()  //  Array statico
        {
            object[] elenco = new object[10];
            elenco[0] = "Pippo";
            elenco[1] = 120;
            elenco[2] = 3.14;
            elenco[3] = new Point(10, 10);
            elenco[4] = 6.28;
            Display(elenco);

            #region Linq

            //Display(from o in elenco
            //        where o != null
            //        select o);

            //Display(from o in elenco
            //        where o is double
            //        select o);

            //Display(from o in elenco
            //        where o is double
            //        select (double) o);

            //Display(elenco.OfType<double>());

            #endregion
        }

        private static void Step2()  //  List<object>
        {
            List<object> elenco = new List<object>();
            elenco.Add("Pippo");
            elenco.Add(120);
            elenco.Add(3.14);
            elenco.Add(new Point(10, 10));
            elenco.Add(6.28);
            Display(elenco);

            #region Linq

            //Display(from o in elenco
            //        where o is double
            //        select o);

            #endregion
        }

        private static void Step3()  //  List<Point>
        {
            List<Point> elenco = new List<Point>();
            elenco.Add(new Point(10, 10));
            elenco.Add(new Point(20, 20));
            elenco.Add(new Point(30, 30));
            elenco.Add(new Point(40, 40));
            Display(elenco);

            #region Linq

            //Display(from o in elenco
            //        where o.X > 20
            //        select o);

            #endregion
        }

        private static void Step4()  //  class PointsList : List<Point>
        {
            PointsList elenco = new PointsList();
            elenco.Add(10, 10);
            elenco.Add(20, 20);
            elenco.Add(30, 30);
            elenco.Add(40, 40);
            Display(elenco);

            #region Linq

            //Display(from o in elenco
            //        where o.X > 20
            //        select o);

            #endregion
        }

        private static void Step4B()  //  List<Point> + metodo di estensione
        {
            List<Point> elenco = new List<Point>();
            elenco.Add(10, 10);
            elenco.Add(20, 20);
            elenco.Add(30, 30);
            elenco.Add(40, 40);
            Display(elenco);
        }

        private static void Step5()  //  class Points
        {
            Points elenco = new Points();
            elenco.Add(10, 10);
            elenco.Add(20, 20);
            elenco.Add(30, 30);
            elenco.Add(40, 40);
            Display(elenco);

            #region Linq

            //Display(from o in elenco
            //        where o.X > 20
            //        select o);

            #endregion
        }

        private static void Step6()  //  class Points & Linq
        {
            Points elenco = Points.CreateRandomInstance(100);
            Display(elenco);

            #region Linq

            //Display(from p in elenco
            //        orderby p.X, p.Y
            //        select p);

            //Display(from p in elenco
            //        orderby p.X, p.Y descending
            //        select p);

            //Display((from p in elenco
            //         where p.X > p.Y
            //         orderby p.X
            //         select p.X).Distinct());

            //Display(from p in elenco
            //        where p.X > p.Y
            //        group p by p.X into pg
            //        where pg.Count() > 1
            //        orderby pg.Count(), pg.Key
            //        select new { X = pg.Key, Count = pg.Count() });

            #endregion
        }

        private static void Display<T>(IEnumerable<T> elenco)
        {
            Console.WriteLine("T = {0}", typeof(T).Name);
            foreach (T o in elenco)
                Console.WriteLine("{0}", o);
            Console.WriteLine("----------");
        }

        private static void Step7()  //  GUIDs
        {
            for (int k = 1; k <= 10; k++)
            {
                Console.WriteLine("{0}", Guid.NewGuid());
            }
        }

        private static void Step8A()  //  Composizione e delega
        {
            Delfino_A delfino = new Delfino_A();
            delfino.Service1();
            delfino.Service2();
            delfino.Service3();
            delfino.Service4();
            delfino.Service5();
            Console.WriteLine("delfino is Mammifero = {0}", delfino is Mammifero);
            Console.WriteLine("delfino is AnimaleAcquatico = {0}", delfino is IAnimaleAcquatico);
            Console.WriteLine("----------");
        }

        private static void Step8B()  //  Interfaccia
        {
            Delfino_B delfino = new Delfino_B();
            delfino.Service1();
            delfino.Service2();
            delfino.Service3();
            delfino.Service4();
            delfino.Service5();
            Console.WriteLine("delfino is Mammifero = {0}", delfino is Mammifero);
            Console.WriteLine("delfino is AnimaleAcquatico = {0}", delfino is IAnimaleAcquatico);
            Console.WriteLine("----------");
        }

        private static void Step8C()  //  Interfaccia + Composizione e delega
        {
            Delfino_C delfino = new Delfino_C();
            delfino.Service1();
            delfino.Service2();
            delfino.Service3();
            delfino.Service4();
            delfino.Service5();
            Console.WriteLine("delfino is Mammifero = {0}", delfino is Mammifero);
            Console.WriteLine("delfino is AnimaleAcquatico = {0}", delfino is IAnimaleAcquatico);
            Console.WriteLine("----------");
        }
    }
}
