﻿using System;
using System.Linq;
using System.Text;
using System.Collections;
using System.Collections.Generic;

namespace Esempio2
{
    public class Points : IEnumerable<Point>
    {
        private readonly List<Point> _points = new List<Point>();

        public int Count
        {
            get { return _points.Count; }
        }

        public void Add(int x, int y)
        {
            _points.Add(new Point(x, y));
        }

        public static Points CreateRandomInstance(int count, Random random = null)
        {
            if (count <= 0)
                throw new ArgumentException("count <= 0");
            random = random ?? new Random();  //  (random != null) ? random : new Random()
            Points points = new Points();
            for (int k = 0; k < count; k++)
                points.Add(random.Next(0, 100), random.Next(0, 100));
            return points;
        }

        #region IEnumerable<Point> Members

        IEnumerator<Point> IEnumerable<Point>.GetEnumerator()
        {
            return _points.GetEnumerator();
        }

        #endregion

        #region IEnumerable Members

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _points.GetEnumerator();
        }

        #endregion
    }
}
