#include "biblioteca.h"

int leggiLibri (char* nomefile, Libro l[]){
	int i;
	FILE * fp;

	if((fp=fopen(nomefile,"r"))==NULL)
		exit(1);
	i = 0;
	while ((fscanf(fp,"%s %s %s %c %d %d\n",
				l[i].codice, l[i].titolo, l[i].autore,
			       	&(l[i].genere),	&(l[i].anno), &(l[i].copie)) == 6) && (i < max_num_libri)){
        i++;
    }
	fclose(fp);
	return i;
}

void stampaLibro (Libro l){
	printf("\nLibro - Codice: %s\t Titolo: %s\t Autore: %s\t Genere: %c\t Anno: %d\t Copie: %d", l.codice, l.titolo, l.autore, l.genere, l.anno, l.copie);
}

int leggiPrestiti (char* nomefile, Prestito p[]){
	int i;
	FILE * fp;

    i = 0;
	if((fp=fopen(nomefile,"r"))==NULL)
		exit(1);

	while ((fscanf(fp,"%s %s %d %d %d\n",
				p[i].codice, p[i].cliente,
			       	&(p[i].giorno),	&(p[i].mese), &(p[i].anno)) == 5) && (i < max_num_prestiti)){
        i++;
    }
	fclose(fp);
	return i;
}

void stampaPrestito (Prestito p){
	printf("\nPrestito - Codice: %s\t Cliente: %s\t Giorno Scadenza: %d\t Mese Scadenza: %d\t Anno Scadenza: %d", p.codice, p.cliente, p.giorno, p.mese, p.anno);
}

int calcolaRitardi(Prestito p[], int dimP){
	int i, nRitardi = 0;
	int meseCorrente, giornoCorrente, annoCorrente;
	printf("\n ----- Prestiti in ritardo ----- ");
        printf("Inserisci anno corrente \t");
	scanf("%d",&annoCorrente);
	printf("Inserisci mese \t");
	scanf("%d",&meseCorrente);
	printf("Inserisci giorno \t");
	scanf("%d",&giornoCorrente);
	for(i=0;i<dimP;i++){
		if(p[i].anno < annoCorrente || (p[i].anno == annoCorrente && p[i].mese < meseCorrente) || (p[i].anno == annoCorrente && p[i].mese == meseCorrente && p[i].giorno < giornoCorrente)){
			stampaPrestito(p[i]);
			nRitardi++;
		}
	}
	return nRitardi;
}

int inserisciPrestito (FILE * fp, Libro l[], int dimL, Prestito p[], int dimP){
	Prestito nuovoPrestito;
	char titolo[dimTitolo];
	int libroDisponibile = 0;
	int i,j, copieInPrestito = 0, numeroPrestiti = 0;
	int annoRest, meseRest, giornoRest;

	printf("\nInseririmento nuovo prestito");
	printf("\nNome Cliente?  ");
	scanf("%s",nuovoPrestito.cliente);
	printf("Titolo Libro?  ");
	scanf("%s",titolo);

	printf("Inserisci anno data restituzione \t");
	scanf("%d",&annoRest);
	printf("Inserisci mese \t");
	scanf("%d",&meseRest);
	printf("Inserisci giorno \t");
	scanf("%d",&giornoRest);

        for(i=0;i<dimL;i++){
		if(!strcmp(titolo,l[i].titolo)){   // il libro rientra nel catalogo della biblioteca
			for(j=0;j<dimP;j++){        // conto il numero di copie attualmente in prestito
				if(!strcmp(l[i].codice,p[j].codice)) 
					copieInPrestito++;
				if(!strcmp(p[j].cliente,nuovoPrestito.cliente))   // conto il numero di prestiti attivi per il cliente
					numeroPrestiti++; 
			}
			if(l[i].copie-copieInPrestito >= 1 && numeroPrestiti <= 2){   // almeno una copia del libro richiesto è disponibile e non ci sono più di 2 prestiti attivi
				libroDisponibile=1;
				strcpy(nuovoPrestito.codice,l[i].codice);
				nuovoPrestito.giorno=giornoRest;
				nuovoPrestito.mese=meseRest;
				nuovoPrestito.anno=annoRest;
			}
		}
	}

	//stampa di debug
	stampaPrestito(nuovoPrestito);

	if(!libroDisponibile)
		return -1;

	fprintf(fp,"%s %s %d %d %d",nuovoPrestito.codice,nuovoPrestito.cliente,nuovoPrestito.giorno,nuovoPrestito.mese,nuovoPrestito.anno);

	return 0;
}

void scambia(Libro* a, Libro* b){
    Libro temp;
    temp = *a;
    *a = *b;
    *b = temp;
}


void ordina (Libro libri[], int dimL){
    // bubble sort
    int i;
    int ordinato = 0;
    while (dimL > 1 && ordinato == 0){
        ordinato = 1;
        for(i = 0; i < dimL - 1; i++){
            if(libri[i].anno > libri[i+1].anno){
                scambia(&libri[i], &libri[i+1]);
                ordinato = 0;
            }
        }
        dimL--;
    }
}
