package esempioseggio; 

public class Seggio 
{
  private boolean[] elettori;	 								
  private int[] votiListe;		
	private int votanti;
  								
  public Seggio(int numListe,int numElettori) 
	{	
    elettori=new boolean[numElettori];			
    votiListe=new int[numListe];				
    inizia();									
  }

  public void inizia()
	{							
		votanti = 0;
    for (int i=0; i < elettori.length; i++)		
      elettori[i]=false;
    for (int i=0; i < votiListe.length; i++)
      votiListe[i]=0;
  }

  public boolean vota(int elettore,int lista)
	{	
		boolean  votoOk =
      elettore <= elettori.length	&& elettore > 0 &&										
      lista <= votiListe.length && lista > 0 &&
			elettori[elettore-1] == false;

    if (votoOk)
		{				
       elettori[elettore-1] = true;
       votiListe[lista-1]++;
			 votanti++;
       return true;
    }
    else return false;
  }

  public int getVotanti()
	{
		 return votanti;	
  }

  public double getPercentuale(int lista)
	{		
    if (votanti > 0)						
	    return (votiListe[lista-1] *100.0) / votanti;
	  else return 0;
  }

  public int getVincente()
	{						
    int indice=0;								
    int max=0;									

    for (int i=0; i < votiListe.length; i++)	
      if (max < votiListe[i])
			{				
        max = votiListe[i];						
        indice = i;								
      }											
    return (indice+1);
  }  
}
