package garage;

import java.io.*;

import veicoli.*;

public class MainGarage {
	
	public static void main(String[] args)
		throws IOException 
	{
		Automobile a;
		Furgone f;
		Motocicletta m;
		int annoImmatricolazione;
		String marca;
		String tipoAlimentazione;
		int cilindrata;
		int capacitaCarico;
		int numPorte;
		String tipologia;
		int numTempiMotore;
		
		int inputInt;
		
		Garage garage = new Garage();
		
		BufferedReader kbd =
      new BufferedReader(new InputStreamReader(System.in));

    
    String st = "";
    String input = "";
    while(!st.equals("*"))
    {
    	
      System.out.println("Garage pubblico: ");
      System.out.println("1 per inserire un'automobile");
      System.out.println("2 per inserire una motocicletta");
      System.out.println("3 per inserire un furgone");
      System.out.println("4 per liberare un posto");
      System.out.println("5 per stampare la situazione corrente dei posti");
      System.out.println("* per uscire");
      
      st = kbd.readLine();
      
      if(!st.equals("*")){
      	/* Gestione dell'eccezione che pu essere lanciata dal metodo parseInt
       	 * qualora l'utente non digiti un numero.
       	 */
      	try
      	{
      		inputInt = Integer.parseInt(st);
      	
      		switch(inputInt)
      		{
      			case 1:
      				System.out.println("Inserisci l'anno di immatricolazione:");
      				input = kbd.readLine();
      				annoImmatricolazione = Integer.parseInt(input);
      				System.out.println("Inserisci la marca:");
      				marca = kbd.readLine();
      				System.out.println("Inserisci il tipo di alimentazione:");
      				tipoAlimentazione = kbd.readLine();
      				System.out.println("Inserisci la  cilindrata:");
      				input = kbd.readLine();
      				cilindrata = Integer.parseInt(input);   
      				System.out.println("Inserisci il numero di porte:");
      				input = kbd.readLine();
      				numPorte = Integer.parseInt(input);  
      			
      				a = new Automobile(annoImmatricolazione, marca, tipoAlimentazione, cilindrata, numPorte);
      				//si noti l'uso del subtyping ed il polimorfismo del metodo 'immettiNuovoVeicolo'
      				garage.immettiNuovoVeicolo(a);      			
      			
      				/* fa in modo che il controllo passi alla fine dello switch e che non 
      				 * siano eseguiti i case successivi.
      			 	 */
      				break;
      			    	   	
      			case 2:
       				System.out.println("Inserisci l'anno di immatricolazione:");
      				input = kbd.readLine();
      				annoImmatricolazione = Integer.parseInt(input);
      				System.out.println("Inserisci la marca:");
      				marca = kbd.readLine();
      				System.out.println("Inserisci il tipo di alimentazione:");
      				tipoAlimentazione = kbd.readLine();
      				System.out.println("Inserisci la  cilindrata:");
      				input = kbd.readLine();
      				cilindrata = Integer.parseInt(input);   
      				System.out.println("Inserisci il tipo di motocicletta (strada, enduro, motocross, ...):");
      				tipologia = kbd.readLine();
      				System.out.println("Inserisci il numero dei tempi del motore:");
      				input = kbd.readLine();
      				numTempiMotore = Integer.parseInt(input);      	   	
      	
      				m = new Motocicletta(annoImmatricolazione, marca, tipoAlimentazione, cilindrata, tipologia, numTempiMotore);
      				//si noti l'uso del subtyping e del polimorfismo del metodo 'immettiNuovoVeicolo'
      				garage.immettiNuovoVeicolo(m);     			
      			
      				/* fa in modo che il controllo passi alla fine dello switch e che non 
      			 	 * siano eseguiti i case successivi.
      			 	 */
      				break;
      		
      			case 3:
      				System.out.println("Inserisci l'anno di immatricolazione:");
      				input = kbd.readLine();
      				annoImmatricolazione = Integer.parseInt(input);
      				System.out.println("Inserisci la marca:");
      				marca = kbd.readLine();
      				System.out.println("Inserisci il tipo di alimentazione:");
      				tipoAlimentazione = kbd.readLine();
      				System.out.println("Inserisci la  cilindrata:");
      				input = kbd.readLine();
      				cilindrata = Integer.parseInt(input);
      				System.out.println("Inserisci la capacit di carico:");
      				input = kbd.readLine();
      				capacitaCarico = Integer.parseInt(input);
      	
      				f = new Furgone(annoImmatricolazione, marca, tipoAlimentazione, cilindrata, capacitaCarico);
      				//si noti l'uso del subtyping e del polimorfismo del metodo 'immettiNuovoVeicolo'
      				garage.immettiNuovoVeicolo(f);      		
      			
      				/* fa in modo che il controllo passi alla fine dello switch e che non 
      			 	 * siano eseguiti i case successivi.
      			 	 */
      				break;
      		
      			case 4:
      				System.out.println("Inserisci il numero del posto che si sta liberando:");
      				input = kbd.readLine();
      				int posto = Integer.parseInt(input);
      	
      				garage.estraiVeicolo(posto);      		
      			
      				/* fa in modo che il controllo passi alla fine dello switch e che non 
      			 	 * siano eseguiti i case successivi.
      			   */
      				break;
      		
      			case 5:
      				System.out.println("Situazione corrente dei posti nel garage");
      				garage.stampaSituazionePosti();      		
      			
      				/* fa in modo che il controllo passi alla fine dello switch.
      			   */
      				break;
      		
      		}//switch
      	
      	}catch( NumberFormatException nfe){
      		System.out.println("Non  stato digitato un numero!");
      	}
      }//if
      
    }//while
    
	}//main	
}
