package veicoli;

public class Motocicletta extends VeicoloAMotore {
	
	protected String tipologia; //"strada", "enduro", "motocross", ...
	protected int numTempiMotore;
	
	public Motocicletta()
	{
		//richiamo del costruttore senza parametri della classe base (VeicoloAMotore)
		super();
		tipologia = "";
		numTempiMotore = 0;
	}
	
	public Motocicletta(int a, String m, String t, int c, String tip, int tm)
	{
		//richiamo del costruttore con parametri della classe base (VeicoloAMotore)
		super(a, m, t, c);
		tipologia = tip;
		numTempiMotore = tm;
	}
	
	public String getTipologia()
	{
		return tipologia;
	}
	
	public void setTipologia(String t)
	{
		tipologia = t;
	}
	
	public int getNumTempiMotore()
	{
		return numTempiMotore;
	}
	
	public void setNumTempiMotore(int tm)
	{
		numTempiMotore = tm;
	}
	
	//override del metodo toString
	public String toString()
	{
		return "\tMotocicletta\n"
						+ super.toString()	//richiamo esplicito del metodo toString della classe base VeicoloAMotore
						+ "\tNumero Tempi Motore:" + numTempiMotore + "\n";
	}
	
	/*
	 * ...invece di:
	 *
	public String toString()
	{
		return "\tMotocicletta\n"
						+ "\tAnno Immatricolazione:"+ annoImmatricolazione + "\n"
						+ "\tMarca:" + marca + "\n"
						+ "\tAlimentazione:" + tipoAlimentazione + "\n"
						+ "\tCilindrata:" + cilindrata + "\n"
						+ "\tTipologia:" + tipologia + "\n"
						+ "\tNumero Tempi Motore:" + numTempiMotore + "\n";
	}
	*/

}
