public class ContoCorrente 
{
  private double[] movimenti;
  private double saldo;
  private int count;

  public ContoCorrente(int maxMov) 
	{
    movimenti = new double[maxMov];
		azzera();
  }

  public void azzera()
	{
    for (int i=0; i<movimenti.length; i++)
      movimenti[i] = 0;
    saldo = 0;
    count = 0;
  }

  public void deposita(double importo)
	{
    if (count<movimenti.length)
		{
       movimenti[count] = importo;
       saldo += importo;
       count++;
    }
  }

  public void preleva(double importo)
	{
    if (count<movimenti.length && saldo>=importo)
		{
       movimenti[count] = -importo;
       saldo -= importo;
       count++;
    }
  }

  public double getSaldo()
	{
    return saldo;
  }

  public int getMovCount()
	{
    return count;
  }

  public double getMov(int num)
	{
    if (num>0 && num<=count+1)
      return movimenti[num-1];
    else return 0;
  }

  public double calcolaMax()
	{
    double max=0;

    for (int i=0; i<movimenti.length; i++)
			if (Math.abs(movimenti[i])>max)
			  max = Math.abs(movimenti[i]);

    return max;
}