/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2x;

import SQLite.Exception;
import SQLite.JDBC2x.JDBCConnection;
import SQLite.JDBC2x.JDBCResultSet;
import SQLite.JDBC2x.TableResultX;
import SQLite.TableResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class JDBCStatement
implements Statement {
    private JDBCConnection conn;
    protected JDBCResultSet rs;
    protected int updcnt;

    public JDBCStatement(JDBCConnection jDBCConnection) {
        this.conn = jDBCConnection;
    }

    public void setFetchSize(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public int getMaxRows() throws SQLException {
        return 0;
    }

    public void setMaxRows(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        return 1004;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.conn.timeout = n * 1000;
        if (this.conn.timeout < 0) {
            this.conn.timeout = 120000;
        } else if (this.conn.timeout < 1000) {
            this.conn.timeout = 5000;
        }
    }

    public int getQueryTimeout() throws SQLException {
        return this.conn.timeout;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet executeQuery(String string, String[] stringArray, boolean bl) throws SQLException {
        TableResult tableResult = null;
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        this.updcnt = -1;
        if (this.conn == null || this.conn.db == null) {
            throw new SQLException("stale connection");
        }
        int n = 0;
        boolean bl2 = !this.conn.autocommit && !this.conn.intrans;
        while (true) {
            try {
                if (bl2) {
                    this.conn.db.exec("BEGIN TRANSACTION", null);
                    this.conn.intrans = true;
                }
                if (stringArray == null) {
                    if (bl) {
                        this.conn.db.exec(string, null);
                    } else {
                        tableResult = this.conn.db.get_table(string);
                    }
                } else if (bl) {
                    this.conn.db.exec(string, null, stringArray);
                } else {
                    tableResult = this.conn.db.get_table(string, stringArray);
                }
                this.updcnt = (int)this.conn.db.changes();
            }
            catch (Exception exception) {
                if (this.conn.db.is3() && this.conn.db.last_error() == 5 && this.conn.busy3(this.conn.db, ++n)) {
                    try {
                        if (bl2 && this.conn.intrans) {
                            this.conn.db.exec("ROLLBACK", null);
                            this.conn.intrans = false;
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        int n2 = 20 + n * 10;
                        if (n2 > 1000) {
                            n2 = 1000;
                        }
                        JDBCStatement jDBCStatement = this;
                        synchronized (jDBCStatement) {
                            this.wait(n2);
                            continue;
                        }
                    }
                    catch (java.lang.Exception exception3) {
                        continue;
                    }
                }
                throw new SQLException(exception.toString());
            }
            break;
        }
        if (!bl && tableResult == null) {
            throw new SQLException("no result set produced");
        }
        if (!bl && tableResult != null && tableResult.ncolumns > 0) {
            this.rs = new JDBCResultSet(new TableResultX(tableResult), this);
        }
        return this.rs;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(string, null, false);
    }

    public boolean execute(String string) throws SQLException {
        return this.executeQuery(string) != null;
    }

    public void cancel() throws SQLException {
        if (this.conn == null || this.conn.db == null) {
            throw new SQLException("stale connection");
        }
        this.conn.db.interrupt();
    }

    public void clearWarnings() throws SQLException {
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public void addBatch(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException("not supported");
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("not supported");
    }

    public void close() throws SQLException {
        this.conn = null;
    }

    public int executeUpdate(String string) throws SQLException {
        this.executeQuery(string, null, true);
        return this.updcnt;
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        return false;
    }

    public int getUpdateCount() throws SQLException {
        return this.updcnt;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void setCursorName(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("not supported");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (n != 2) {
            throw new SQLException("not supported");
        }
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean execute(String string, int n) throws SQLException {
        if (n != 2) {
            throw new SQLException("not supported");
        }
        return this.execute(string);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }
}

