
/*
 * Dichiarazione della classe
 */
public class Counter 
{

    /* *******************************************************************************
     * ------ Dichiarazione degli attributi della classe (in questo caso uno solo).---
     * *******************************************************************************
     */
    /* Nota: tipicamente gli attributi si definiscono con visibilit private
     * in modo che non siano accessibili in maniera diretta ma soltanto
     * attraverso i metodo get e set (incapsulamento).
     */
    private int val;



  /* *******************************************************************************
	 * ------ Dichiarazione dei metodi della classe ----------------------------------
	 * *******************************************************************************
   */

	/* *******************************************************************************
	   Costruttori della classe.
	 * *******************************************************************************
	 */

    /* Costruttore senza parametri
     * ( invocato a fronte dell'istruzione Counter c = new Counter(); )
     */
    public Counter() 
    {
           val=0; //inizializzazione del campo della classe
    }

    /* Costruttore con parametro intero.
     * ( invocato a fronte dell'istruzione: Counter c = new Counter(6); )
     */
    public Counter(int v) 
    {
           //inizializzazione del campo della classe con il valore passato come parametro
           setVal(v);
    }


	/* *******************************************************************************
	   Metodi di accesso agli attributi.
	 * *******************************************************************************
	 */

    /*
     * Imposta l'attributo val al valore passato come parametro.
     */
    public void setVal(int v)
    {
            val=v;
    }

    /*
	   * Restituisce il valore dell'attributo val.
	   */
	  public int getVal()
	  {
	       return val;
    }


	/* *******************************************************************************
	   Metodi di utilit della classe.
	 * *******************************************************************************
	 */
    /*
     * Pone a zero il valore del contatore
     */
    public void reset()
    {
           val=0;
    }


    /*
     * Incrementa di una unit il valore corrente del contatore
     */
    public void inc()
    {
           val++;
    }

    /*
     * Increment di v unit il valore corrente del contatore
     *
     * Nota: il metodo mantiene lo stesso qualificatore (public), lo stesso valore di
     * ritorno (void) e lo stesso nome (inc) del metodo precedente, ma cambia il
     * numero ed il tipo dei parametri (int v in luogo di nessun parametro).
     * (Overloading del metodo inc)
     */
    public void inc(int v)
    {
           val+=v;
    }
	
}