package calendar;

import counter.Counter;

	
/*
 * Classe per la gestione di un calendario, attraverso l'uso di array
 */
public class Calendario 
{
	
	/*
	 * Negli array aggiungo un primo elemento non significativo, in modo
	 * da poter avere una corrispondenza diretta tra rappresentazione 
	 * numerica del mese ed indice della posizione nell'array, al quale 
	 * reperisco le informazioni relative (giorni del mese o nome).
	 */
  private int[] giorni_mesi=
  {
   	0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
  };  //N.B. dimensione 13 (elemento di indice 0 non significativo)
     								
  private String[] nomi_mesi=
  {
    "", "Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio"
    , "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre"
    , "Novembre", "Dicembre"
  };  //N.B. dimensione 13 (elemento di indice 0 non significativo)
    
  private Counter anno;
     
  private Counter mese;
    
  private Counter giorno;
  
  
  public Calendario()
  {
  	//impostazione di default al primo Gennaio 2007
  	giorno = new Counter();
  	mese = new Counter();
  	anno = new Counter();
  	setCurrentData(1,1,2007);
  	checkBisestile();
  }
  
  public Calendario(int g, int m, int a)
  {
   	giorno = new Counter();
  	mese = new Counter();
  	anno = new Counter();
  	setCurrentData(g,m,a);
  	checkBisestile();
  }
     
  public int getGiorniMese(int m)
  {
  	if ((m>=1) && (m<=12))
  		return giorni_mesi[m];
  	else
  		//se il parametro ha un valore errato ritorno -1	
  		return -1;
  }
    
  public int getGiorniMese(String m)
  {
  	//ricerca del nome del mese nell'array
  	int i = 1;
  	while ( (i < nomi_mesi.length) && (!m.equalsIgnoreCase(nomi_mesi[i])) ){
  		i++;
  	}
  	if(i == nomi_mesi.length) //la stringa m non  un nome di mese
  		return -1;
  	else
  		//la stringa m  stata trovata nel'array nomi_mesi
  		return giorni_mesi[i];
  }
  
  public boolean checkBisestile()
  {
  	/* 
  	 * Un anno  bisestile se  divisibile per 400 oppure 
  	 * divisibile per 4 ma non per 100.
  	 */
  	if(
  				(anno.getVal() % 4 == 0 && anno.getVal() % 100 != 0) 
  			|| anno.getVal() % 400 == 0
  		)
  	{
  		giorni_mesi[2] = 29;
  		return true;
  	}else
  		return false;
  }
  
  public void incGiorno(){
  	if(giorno.getVal() == giorni_mesi[mese.getVal()])
  	{
  		// l'ultimo giorno del mese
  		giorno.setVal(1);
  		incMese();
  	}else
  		{
  			giorno.inc();
  		}
  	
  }
  
  public void incMese(){
  	if(mese.getVal() == 12){
  		mese.setVal(1);
  		incAnno();
  	}else
  		{
  			mese.inc();
  		}
  	//controllo che il numero del giorno sia entro i limiti
  	//del nuovo mese impostato
  	if(giorno.getVal() > giorni_mesi[mese.getVal()])
  		//correggo il numero del giorno al massimo del mese impostato
  		giorno.setVal(giorni_mesi[mese.getVal()]);
  }
  
  public void incAnno(){
  	anno.inc();
  }
  
  public void setCurrentData(int g, int m, int a){	
  	if ((m>=1) && (m<=12)){
  		mese.setVal(m);
   		if ((g>=1) && (g<=giorni_mesi[m]))
  			giorno.setVal(g);
  		else
  			giorno.setVal(1); 		
  	}
  	else{
  		mese.setVal(1);
    	if ((g>=1) && (g<=giorni_mesi[1]))
  			giorno.setVal(g);
  		else
  			giorno.setVal(1); 		
  	}
  		
   	if (a>=0)
  		anno.setVal(a);
  	else
  		anno.setVal(2007);
  }
  
  //Stringa in input nella forma gg/mm/aaaa
  public void setCurrentData(String d){
  	int giorno;
  	int mese;
  	int anno;
  	String s;
  	String giornoStr;
  	String meseStr;
  	String annoStr;
  	int i = d.indexOf('/');
  	if(i != -1){
  		//il carattere '/' esiste nella stringa
  		giornoStr = d.substring(0,i);
  		giorno = Integer.decode(giornoStr).intValue();
  		
  		s=d.substring(i+1);
  		i = s.indexOf('/');
  		if(i != -1){
  			//il carattere '/' esiste nella stringa
  			meseStr = s.substring(0,i);
  			mese = Integer.decode(meseStr).intValue();
  			
  			if(i != s.length()-1){
  				annoStr = s.substring(i+1);
  				anno = Integer.decode(annoStr).intValue();
  				setCurrentData(giorno, mese, anno);
  			}
  		}
  	}
  }
  
  public String getExtendedCurrentData(){
  	return "Giorno:"+giorno.getVal()+" Mese:"+mese.getVal()+"";
  }
  
  public String getSimpleCurrentData(){
  	return ""+giorno.getVal()+"/"+mese.getVal()+"/"+anno.getVal();
  }
  
  
}
