package garage;

import veicoli.VeicoloAMotore;

public class Garage {
	
	/*
	 * Sfruttando il subtyping potr indifferentemente immettere nell'array
	 * oggetti di classe automobile, furgone, motocicletta (e di eventuali 
	 * altri classi ottenute estendendo la classe base VeicoloAMotore).
	 */
	private VeicoloAMotore[] veicoli;	//si sfrutta il subtyping
	
	private int numPosti;
	
	public Garage()
	{
		numPosti = 15;
		veicoli = new VeicoloAMotore[numPosti];	
		/* inizializzazione del vettore con tutti i posti liberi.
		 * Uso la convenzione: elemento==null --> posto libero
		 */
		for (int i=0; i<numPosti; i++)
			veicoli[i] = null;
	}
	
	public int getNumPosti()
	{
		return numPosti;
	}
	
	public void setNumPosti(int p)
	{
		numPosti = p;
	}
	
	/*
	 * Metodo polimorfo che grazie al subtyping potr accettare come 
	 * parametro oggetti di qualunque classe che estende dalla classe
	 * base VeicoloAMotore (nel nostro caso Automobile, Motocicletta, Furgone)
	 */
	public int immettiNuovoVeicolo(VeicoloAMotore v)
	{
		//cerco la prima posizione libera
		int i = 0;
		while( i<numPosti && veicoli[i]!=null)
			i++;
		if(i == numPosti)	//non ci sono posti liberi
			return -1;
		//inserisco il veicolo
		veicoli[i] = v;
		return i;
	}
	
	public VeicoloAMotore estraiVeicolo(int posto)
	{
		VeicoloAMotore v;
		//controllo del parametro di input
		if( posto>=0 && posto<numPosti){
			v = veicoli[posto];
			veicoli[posto] = null;
			return v;
		}
		return null;
	}
	
	public void stampaSituazionePosti()
	{
		for(int i=0; i<numPosti; i++)
		{
			if(veicoli[i] == null)
				System.out.println("Posto n." + i +": libero.");
				else
					System.out.println("Posto n." + i +":" + veicoli[i]);
		}
	}
	
}
