package veicoliEcologia;

import veicoli.Motocicletta;
import ecologia.IVeicoloEcologia;

public class MotociclettaEco extends Motocicletta implements IVeicoloEcologia
{
	protected String targa;
	protected String proprietario; //cognome e nome
	protected boolean catalizzatoreMarmitta;
	protected String tipoIniettori;
	
	public MotociclettaEco(int a, String m, String t, int cil, String tip, int tm,
										String targa, String propr, boolean catalizzatore, String iniettori)
	{
		super(a,m,t,cil,tip, tm);
		setTarga(targa);
		setProprietario(propr);
		setCatalizzatoreMarmitta(catalizzatore);
		setIniettori(iniettori);
	}
	
	public void setTarga(String targa)
	{
		this.targa = targa;
	}
	
	public void setProprietario(String proprietario)
	{
		this.proprietario = proprietario;
	}

	public void setCatalizzatoreMarmitta(boolean catal)
	{
		catalizzatoreMarmitta = catal;
	}
	
	public void setIniettori(String tipoIniettori)
	{
		this.tipoIniettori = tipoIniettori;
	}
	
	//implementazione metodi interfaccia IVeicoloEcologia
	
	public boolean isEcologico()
	{
		return (catalizzatoreMarmitta && tipoIniettori.equals("E45"));
	}
	
	public String getTarga()
	{
		return targa;
	}
	
	public String getCognomeNome()
	{
		return proprietario;
	}
	
	public String getInfoVeicolo()
	{
		return super.toString();
	}
}
