package controlloAccessi;

import ecologia.IVeicoloEcologia;


public class ControlloAccessi {
	
	public static boolean canAccess(IVeicoloEcologia veicolo)
	{
		return veicolo.isEcologico();
	}
	
	public static String compilaMulta(IVeicoloEcologia veicolo) throws VeicoloEcologicoException
	{
		if(veicolo.isEcologico())
			throw new VeicoloEcologicoException("Eccezione: il veicolo per il quale  stata richiesta la multa  ecologico!");
			
		String multa = "Il veicolo con targa " + veicolo.getTarga() + 
									 ", appartenente a " + veicolo.getCognomeNome() + 
									 "  in contravvenzione in quanto ha acceduto al centro " +
									 "storico senza i necessari requisiti ecologici.";
		return multa;
	}
}
