package esercitazioni.orologi;

import java.util.StringTokenizer;
import esercitazioni.ora.Ora;
import esercitazioni.calendario.Calendario;
/**
 * <p>
 *Classe base astratta.Questo attributo fa si che non sia possibile istanziarla direttamente 
 *ma che lo si debba fare indirettamente attraverso una sua classe derivata. Tale classe si prefigge di
 *indicare quali metodi debbano essere obbligatoriamente derivati (quelli definiti abstract) e di
 *contenere dei comportamenti di base validi per tutte le  sue subclassi.
 *Notare che i metodi get... non necessitano di essere astratti poich dovranno
 *restituire il valore di una variabile contenuta in questa stessa classe
 </p>
 */
public abstract class OrologioBase implements esercitazioni.orologi.Datario {
/**
 * <p>dovr puntare all'istanza della classe incaricata di gestire l'orario</p>
 */
    public esercitazioni.ora.Ora ora;
/**
 * <p>
 * dovr puntare all'istanza della classe incaricata di gestire la data</p>
 </p>
 */
    protected esercitazioni.calendario.Calendario data;

/**
 *Attributi create per salvare le carattristiche dell'orologio
 */	
	private String tipo, movimento, ricarica, marca, modello;
	private double prezzo;
/**
 * <p>Costruttore: eseguire le necessarie inizializzazioni</p>
 *l'inizializzazione di ora e calendario si preferisce effettuarlo
 *attraverso l'uso di metodi affinch una inizializzazione specifica
 *possa essere effettuata attraverso l'overriding in sub classi
 * 
 */
    public  OrologioBase() {        
        // inizializza l'ora
		initOra();
        // inizializza la data
		initData();
		//forza gli attributi ad un valore di default
		tipo=movimento=ricarica=marca=modello="NON ASSEGNATO";
		prezzo=0.0;
    } 

/**
 * <p>Si prende carico di inizializzare l'ora </p>
 *da non confonder con il metodo setOra che serve ad impostare l'ora
 *mentre in questo caso viene creata un'istanza nuova in memoria della
 *classe Ora
 * 
 */
    protected void initOra() {        
        ora=new Ora();
    } 

/**
 * <p>Si prende carico di inizializzare la data</p>
 *da non confonder con il metodo setData che serve ad impostare la data
 *mentre in questo caso viene creata un'istanza nuova in memoria della
 *classe Calendario
 * 
 */
    public void initData() {        
        data= new Calendario();
    } 
/**
 * <p>
 Il tipo di orologio pu essere ad esempio ANALOGICO o DIGITALE
 </p>
 * 
 * @param tipo 
 */
    public void setTipo(String tipo){
		this.tipo=tipo;
	}

/**
 * <p>ritorna il tipo</p>
 * @return 
 */
    public String getTipo() {        
        return tipo;
    } 

/**
 * <p>Il movimento pu essere ad esempio MECCANICO o ELETTRONICO</p>
 * @param mov 
 */
    public void setMovimento(String mov){
		movimento=mov;
	}

/**
 * 
 * @return 
 */
    public String getMovimento() {        
        return movimento;
    } 

/**
 * <p>
 *La ricarica ad esempio pu valere MANUALE o a BATTERIA
 </p>
 * 
 * @param ricarica 
 */
    public void setRicarica(String ricarica){
		this.ricarica=ricarica;
	}
/**
 */
    public String getRicarica() {        
        return ricarica;
    } 

/**
 * <p>Marca dell'orologio</p>
 * 
 * @param marca 
 */
    public void setMarca(String marca) {        
        this.marca=marca;
    } 

/**
 */
    public String getMarca() {        
        return marca;
    } 

/**
 * <p>Modello di orologio</p>
 * 
 * @param mod 
 */
    public void setModello(String mod) {        
        modello=mod;
    } 

/**
 */
    public String getModello() {        
        return modello;
    } 

/**
 * <p>Costo</p>
 * 
 * @param prezzo 
 */
    public void setPrezzo(double prezzo) {        
		if(prezzo<0.0) 
			prezzo=0.0;
        this.prezzo=prezzo;
    } 

/**
 */
    public double getPrezzo() {        
        return prezzo;
    } 

/**
 * <p>Questo metodo rappresenta l'overriding dell'omonimo metodo dichiarato
 *nella classe Object da cui implicitamente questa classe deriva. Passando
 *una variabile che punti all'istanza di questa classe ad un metodo che richiada 
 *una stringa come parametro, automaticamente richimer qusto metodo.
 *Automatismo da sfruttare ad esempio per stampare le caratteristiche 
 *dell'orologio
 *
 </p>
 * 
 * @return 
 */
    public String toString() {        
        return 
			"Marca :"+getMarca()
			+"\nModello :"+getModello()
			+"\nPrezzo :"+getPrezzo()
			+"\nTipo :"+getTipo()
			+"\nMovimento :"+getMovimento()
			+"\nRicarica :"+getRicarica()
		;
    } 

/**
 * Sfruttando il metodo messo a disposizione dalla classe Calendario
 *ritorna la stringa della data
 */
    public String getData() {        
        return data.getData();
    } 

/**
 * Sfruttando il metodo messo a disposizione dalla classe Calendario
 *imposta la data dell'orologio
 */
    public void setData(int anno, int mese, int giorno) {        
        data.setAnno(anno, mese, giorno);
    } 
/**
 * Overloading per impostare la data a partire da una stringa indicante
 *la data nel formato gg/mm/aaaa e sfruttando il metodo messo a disposizione 
 *dalla classe Calendario
 */
    public void setData(String data) {
        StringTokenizer st=new StringTokenizer(data, "/");
		String a,m,g;
		if(st.hasMoreTokens()){
			g=st.nextToken();
			if(st.hasMoreTokens()){
				m=st.nextToken();
				if(st.hasMoreTokens()){
					a=st.nextToken();
					this.data.setAnno(Integer.parseInt(a), Integer.parseInt(m), Integer.parseInt(g));
				}
			}
		}
    } 

/**
 * Sfruttando il metodo messo a disposizione dalla classe Ora
 *ritorna la stringa dell'ora
 */
    public String getOra() {        
        return ora.getOre()+":"+ora.getMinuti();
    } 

/**
 * Sfruttando il metodo messo a disposizione dalla classe Ora
 *imposta l'ora dell'orologio
 */
    public void setOra(int h, int m) {        
        ora.setOre(h);
		ora.setMinuti(m);
    } 
/**
 * Overloading per impostare l'ora a partire da una stinga contenente
 *l'ora nel formato hh:mm sfruttando il metodo messo a disposizione dalla classe Ora
 */
    public void setOra(String o) {        
        StringTokenizer st=new StringTokenizer(o, ":");
		String h,m;
		if(st.hasMoreTokens()){
			h=st.nextToken();
			if(st.hasMoreTokens()){
				m=st.nextToken();
				ora.setOre(Integer.parseInt(h));
				ora.setMinuti(Integer.parseInt(m));
			}
		}
    } 

 }
