/**
 *A partire dal codice a disposizione eseguire quantosegue:
 * 1) Trasformare le classi dell'esercizio in modo che le richieste di 
		inizilizzazione degli attributi delle istanze immesse in Catalogo
		avvengano all'interno delle classi relative agli orologi;
 *2) Modificare la classe Catalogo al fine di accettre l'input della nuova classe
 *		OrologioGenerico.
 *3) Creare un metodo della classe calendario che stampi solo ora ed eventuale
 *		data di tutti gli orologi immessi
 */



package esercitazioni.orologi;
//
import java.io.*;
import java.util.StringTokenizer;
import esercitazioni.io.*;
import esercitazioni.orologi.*;
/**
 *Questa classe si prefigge di simulare un catalogo di orologi.
 *E' possibile effettuare le seguenti operazioni:
 *- impostare un array di oggetti di dimensione definita nel costruttore
 *- effettuare un input da tastiera relativamente alle caratteristiche di
 *ciascun elemento dell'array
 *- importare oggetti da file
 *- salvare oggetti da file 
 *- ricercare oggetti in base al modello di orologio
 */
public class Catalogo {

	/**
	 *array contenente gli oggetti orologio.Notare che grazie al subtyping
	 * sufficiente definire un array con il tipo della classe base e successivamente
	 *assegnare a ciascun elemento indifferentemente qualsiasi oggetto di una 
	 *sottoclasse
	*/
    private OrologioBase[] schede;
	
	/**
	 *contatore che tiene conto di quanti elementi dell'array sono stati 
	 *correntemente allocati
	 */
    private int num;
	
	/**
	 *le seguenti variabili indicano la posizione ordinale degli attributi
	 *della classe sui record del file
	 */
	private final int posmarca=1;
	private final int posmodello=2;
	private final int posprezzo=3;
	private final int posora=4;
	private final int posdata=5;
	
	/**
	 *rappresenta la stringa che funge da separatore tra gli attributi sui record
	 *del file
	 */
	private final String separatore="<!---->";
    /**
     *Costruttore con dimensionamento degli oggetti al valore passato comeparametro
     */
    public Catalogo(int max) {
           num=0;
           schede=new OrologioBase[max];

    }
    /**
     *Permette l'input da tastiera delle singole schede del catalogo
     */
    public void aggiungi(OrologioBase o){
			Tastiera t=new Tastiera();
			//
			System.out.print("Quale marca? : ");
			o.setMarca(t.readLine());
			//
			System.out.print("Quale modello? : ");
			o.setModello(t.readLine());
			//
			System.out.print("Quanto costa? : ");
			o.setPrezzo(Double.parseDouble(t.readLine()));
			//
			String s1, s2, s3;
			System.out.println("Adesso imposta l'ora:");
			System.out.print("Ora? : ");
			s1=t.readLine();
			System.out.print("Minuti? : ");
			s2=t.readLine();
			o.setOra(Integer.parseInt(s1), Integer.parseInt(s2));
			//
			System.out.println("Adesso imposta la data:");
			System.out.print("Anno? : ");
			s1=t.readLine();
			System.out.print("Mese (cifre) ? : ");
			s2=t.readLine();
			System.out.print("Giorno (cifre) ? : ");
			s3=t.readLine();
			o.setData(Integer.parseInt(s1), Integer.parseInt(s2), Integer.parseInt(s3));
			//
			schede[num]=o;
			num++;
    }
    /**
     *A partire da una stringa passata come parametro, ne esegue la scomposizione
	 *negli attributi componenti
     */
    public void aggiungi(String stroro){
		StringTokenizer st=new StringTokenizer(stroro, separatore);
		String tipo=st.nextToken();
		OrologioBase ob;
		if(tipo.equals("ANALOGICO")){
			ob=new OrologioMeccanico();
		} else if(tipo.equals("DIGITALE")){
			ob=new OrologioElettronico();
		}else
			ob=null;
		//
		if(ob==null)
			return;
		//
		int i=0;
		while(st.hasMoreTokens()){
			i++;
			switch(i){
				case posmarca:
					ob.setMarca(st.nextToken());
					break;
				case posmodello:
					ob.setModello(st.nextToken());
					break;
				case posprezzo:
					ob.setPrezzo(Double.parseDouble(st.nextToken()));
					break;
				case posora:
					ob.setOra(st.nextToken());
					break;
				case posdata:
					ob.setData(st.nextToken());
					break;
			}
		}
		//
		schede[num]=ob;
		num++;
    }
    /**
     *Ricerca tra le schede quella con il modello passato come parametro
     */
    public OrologioBase cerca(String nm){
           for(int i=0;i<num;i++){
                   if(nm.equals(schede[i].getModello())){
                        return schede[i];
                   }
           }
           //
           return null;
    }
    /**
     * metodo che deve implementare un loop per la ricerca
     * delle schede
     */
     public void findSchede(){
           //oggetto che permette di leggere dalla tastiera
           //l'input dell'utente
           Tastiera t=new Tastiera();
           String st;
           do{
              System.out.println("Scegli '*' per uscire o premi un tasto per continuare;");
              st=t.readLine();
              if(!st.startsWith("*")){
                //preosegue per inserire una nuova scheda
                System.out.println("Quale modello devo cercare?");
                String ins=t.readLine();
                OrologioBase a=cerca(ins);
                if(a!=null)
                    System.out.println(a.toString());
                else
                    System.out.println("Orologio "+ ins+" non trovato");
              }
           }while(!st.startsWith("*"));
     }
    /**
     * metodo che deve implementare un loop per l'aggiunta
     * manuale delle schede
     */
     public void inputSchede(){
           //oggetto che permette di leggere dalla tastiera
           //l'input dell'utente
           Tastiera t=new Tastiera();
           String st;
           do{
              System.out.println("Scegli '*' per uscire o premi un tasto per continuare;");
              st=t.readLine();
              if(!st.startsWith("*")){
                //preosegue per inserire una nuova scheda
                System.out.println("Scegli 'A' per inserire un orologio meccanico;");
                System.out.println("Scegli 'D' per inserire un orologio elettronico;");
                String ins=t.readLine();
                if(ins.equalsIgnoreCase("A")){
                    System.out.println("Inserisci i dati per l'orologio meccanico: ");
                    aggiungi(new OrologioMeccanico());
                }else if(ins.equalsIgnoreCase("D")){
                    System.out.print("Inserisci i dati per l'orologio elettronico: ");
                    aggiungi(new OrologioElettronico());
                }
              }
           }while(!st.startsWith("*"));
     }
     /**
      * metodo che deve implementare la lettura delle schede
      * da un file
      */
      public void loadFile(String flnm){
        try{
             FileReader fr=new FileReader(flnm);
             BufferedReader infile=new BufferedReader(fr);
             String line=infile.readLine();
             while(line!=null){
                aggiungi(line);
				//
                line=infile.readLine();
             }
             //
             infile.close();
         }catch (IOException e){
			 System.out.println(e);
		 }
      }
    /**
     * metodo che deve salvare su file le schede attualmente caricate.
     * Al termine della fase di caricamento si deve avere aggiornato il numero
     * di schede letto in corrispondenza dell'attributo n
     */
    public void saveFile(String flnm) throws IOException{
           FileWriter fw=new FileWriter(flnm);
           PrintWriter outfile=new PrintWriter(fw);
           for(int i=0;i<num;i++){
                outfile.println(
					schede[i].getTipo()
					+separatore
					+schede[i].getMarca()
					+separatore
					+schede[i].getModello()
					+separatore
					+schede[i].getPrezzo()
					+separatore
					+schede[i].getOra()
					+separatore
					+schede[i].getData()
				);
           }
           outfile.close();
    }
    /**
     * Stampa tutte le schede
     */
    public void stampa(){
           for(int i=0;i<num;i++){
                System.out.println(schede[i].toString());
           }
    }
	/**
	 *metodo main che permette di testare la classe
	 */
    public static void main(String[] args) throws IOException{
           //dichiarazione della classe Enciclopedia e creazione
           //della sua istanza
           Catalogo e=new Catalogo(50);
           //input schede da parte dell'utente
           e.inputSchede();
           //salvataggio schede
           e.saveFile("c:\\temp\\orologi.dat");
           //caricamento schede
           e.loadFile("c:\\temp\\orologi.dat");
           //
           e.findSchede();
           //
           e.stampa();

    }
}