
package esercitazioni.ora;
import esercitazioni.counter.*;

/**
 * come rendere accessibile la classe Counter che abbiamo situato
 * in un packege differente da quello corrente ?
 * @poseidon-object-id [Id9cc1am109a683c403mm7872]
 */
public class Ora {
/**
 * dichiarazione di un oggetto di classe Counter con
 * la funzione di mantenere memorizzato il valore delle ore
 * @poseidon-object-id [Id9cc1am109a683c403mm7867]
 */
    private esercitazioni.counter.Counter ora;
/**
 * dichiarazione di un oggetto di classe Counter con
 * la funzione di mantenere memorizzato il valore dei minuti
 * @poseidon-object-id [Id9cc1am109a683c403mm785a]
 */
    private Counter minuti;

/**
 * Si sfrutta la caratteristica dei metodi costruttore per compiere
 * la creazione esplicita degli attributi ore e minuti
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7852]
 */
    public  Ora() {        
        //creazione dell'oggetto ora
        ora= new Counter();
        //creazione dell'oggetto minuti
        minuti=new Counter();
    } 

/**
 * Costruttore che permetta di inizializzare
 * ad un certo orario l'orologio in fase d inizializzazione
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm784a]
 * @param o 
 * @param m 
 */
    public  Ora(int o, int m) {        
        //creazione dell'oggetto ora
        ora= new Counter(o);
        //creazione dell'oggetto minuti
        minuti=new Counter(m);
    } 

/**
 * metodo che consente l'avanzamento dell'ora un minuto alla volta
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7844]
 */
    public void ticM() {        
        minuti.inc();
        check();
    } 

/**
 * Overloading del metodo ticM  che imposta direttamente il valore dei minuti
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm783d]
 * @param m 
 */
    public void ticM(int m) {        
        minuti.set(m+minuti.getValue());
        check();
    } 

/**
 * metodo che consente l'avanzamento dell'ora un'ora alla volta
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7837]
 */
    public void ticH() {        
        ora.inc();
        check();
    } 

/**
 * Overloading del metodo ticH che consente di impostare direttamente
 * il valore dell'ora
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7830]
 * @param h 
 */
    public void ticH(int h) {        
        ora.set(h+ora.getValue());
        check();
    } 

/**
 * Controlla che il valore di ore e minuti sia congruo, ovvero
 * che ore non superi 24 e non sia inferiore a 0 e che minuti
 * sia compreso tra 0 e 59.
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm782a]
 */
    private void check() {        
        if(minuti.getValue()>59){
            /*valuta quante ore intere sono rappresentate
             *nel valore dei minuti, quindi aggiorna i minuti
             *con il valore rappresentato dalla parte frazionaria
             *delle ore
            */
            //minuti frazioni di ora
            int m=minuti.getValue()%60;
            //ore intere relativamente ai minuti impostati
            int o=(minuti.getValue()/60);
            //imposta il valore dei minuti
            minuti.set(m);
            //imposta valore dell'ora
            ora.set(o+ora.getValue());
        }else if(minuti.getValue()<0){
              minuti.reset();
        }
        /*controllo se l'ora  arrivata a 24*/
        if(ora.getValue()>23){
            ora.set(ora.getValue()%24);
        }else if(ora.getValue()<0){
              ora.reset();
        }
    } 

/**
 * metodo che permette l'azzeramento dei valori dell'orologio
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7824]
 */
    public void reset() {        
        //azzera l'ora
        ora.reset();
        //azzera i minuti
        minuti.reset();
    } 

/**
 * metodo che permette di impostare direttamente
 * il valore delle ore
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm781d]
 * @param h 
 */
    public void setOre(int h) {        
        ora.set(h);
        check();
    } 

/**
 * metodo che permette di impostare direttamente
 * il valore dei minuti
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7816]
 * @param m 
 */
    public void setMinuti(int m) {        
        minuti.set(m);
        check();
    } 

/**
 * metodo che permette di conoscere il valore delle ore
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7810]
 * @return 
 */
    public int getOre() {        
        return ora.getValue();
    } 

/**
 * metodo che permette di conoscere il valore dei minuti
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm780a]
 * @return 
 */
    public int getMinuti() {        
        return minuti.getValue();
    } 

/**
 * metodo che ritorna la stringa con l'indicazione
 * dell'ora: motare l'overriding rispetto allo stesso metodo
 * che compare nella classe Object da cui implicitamente
 * Orologio deriva
 * 
 * @poseidon-object-id [Id9cc1am109a683c403mm7804]
 * @return 
 */
    public String toString() {        
              	return 
        			"Sono le ore "+getOre()+" e "+getMinuti()+" minuti";
    } 
/**
 * <p></p>
 * @poseidon-object-id [Id9cc1am109a683c403mm7304]
 */
    public esercitazioni.orologi.OrologioBase orologioBase;
 }
