
 /**
  *  Classe che astrae un <B>Terrestre</B>.
  *  @author:Gianluca Tonti
  */ 
  public class Terrestre{
  	
  	private String nome;
  	private int vita;       //0..100
  	private int velocita;   //0..10
  	private int armamento;  //numero di armi possedute
  	private Arma vet[];
  	
  	/** 
  	 *  Costruttore che inizializza con valori di default 
     *  il terrestre
     */   	
  	public Terrestre(){

        this.nome = "Sconosciuto";
  	    this.vita = 50;
  	    this.velocita = 5;
 
  	    armamento = 0;
  	    vet = new Arma[10];
  	    
        System.out.println("Il Terrestre " + nome + " entra in gioco");
   	}
  		
  	/** 
  	 *  Costruttore che inizializza con i parametri passati per argomento
  	 *  il terrestre
     */   	
  	
  	public Terrestre (String nome, int vita, int velocita, int mxArmi){
        this.nome = nome;
  	    this.vita = vita;
  	    this.velocita = velocita;
 
  	    armamento = 0;
  	    vet = new Arma[mxArmi];
  	    
        System.out.println("Il Terrestre " + nome + " entra in gioco");
  	}	
  	
  	public void addArma(Arma weapon){
    	 if (armamento < vet.length) vet[armamento] = weapon;
    	 armamento++; 
  		}
  	
   /** 
  	* Simulazione di un attacco.
  	*/  
  	public void attaccaMarziani(int scelta){ // attacca i marziani con l'arma
  		
  		if ((scelta<0) || (scelta>=armamento)) return; 
  		
  		if (!vivente()) System.out.println("Non posso attaccare:Sono morto!");
        else {                		   		
  		      //algoritmo di attacco semplificato
  		      vita = vita - 20 + 2 * velocita + vet[scelta].fire();  
  		      if (vita < 0) vita=0; 		      
  	    }      

  	}
  
   /** 
  	* Restituisce <B>true</B> se ancora vivo, altrimenti <B>false</B>.
  	*/    	
  	public boolean vivente(){
  	   if (vita > 0) return true;
  	   else return false;
  	}

  
  /** 
  	* Restituisce <B>true</B> se due oggetti  hanno la stessa vita,
  	* velocita e armamento, altrimenti <B>false</B>.
  	*/ 	  	
	public boolean equals(Terrestre x){ // terrestri equivalenti per definizione se hanno 
										// stessa vita 
										// stessa velocita e  
										// stesso numero di armi
	 if ((vita == x.vita) && (velocita == x.velocita) && (armamento == x.armamento)) return true;
     return false;  	
	}	
	
  
  
  
  	public String toString () {
  		return ("Terrestre " + nome + ". Vita: " + vita);
  	}   
  	
  } // Fine classe Terrestre    	        