public class AlberoBinario {
	Nodo root;
	
	public AlberoBinario() {
		root = null;
	}

	public void addValue(Comparable value) {
 		root = insert(root, value);
 	}
	
	private Nodo insert(Nodo actual, Comparable value){
		if (actual == null) return new Nodo(value);
		if (actual.getValue().compareTo(value)==0) return actual;

		if (actual.getValue().compareTo(value)>0) actual.setSx(insert(actual.getSx(), value));
		else actual.setDx(insert(actual.getDx(), value));
        return actual;				
	}
	
	public String toString(){
      return stringa(root);
	}
	
      private String stringa(Nodo actual){
      String app ;
      if (actual == null) app = "";
      else app = stringa(actual.getSx())+" "+actual.getValue().toString()+" "+stringa(actual.getDx());
      return app;
	}


    public boolean isPresente(Comparable ricerca){
       	return (cerca(ricerca, root)!=null);
    }

    private Nodo cerca(Comparable ricerca, Nodo actual){
	Nodo app;
        if (actual == null) return null;
	if (actual.getValue().compareTo(ricerca)==0) return actual;
        if (actual.getValue().compareTo(ricerca)>0) app = cerca (ricerca, actual.getSx());
	else app = cerca (ricerca, actual.getDx());
	return app;
    }

}
