
import java.io.*;

public class Library {
	private User [] utenti;
	private Author [] autori;
	private Librarian [] bibliotecari;
	private Book   [] libri;

	private int indxAutori;
	private int indxUtenti;
	private int indxbibliot;
	private int indxLibri;

	private String nome; 
	
	public Library (String nome){
		this.nome = nome;
		autori = new Author [30];
		libri  = new Book [200];
		utenti = new User [200];
		bibliotecari = new Librarian [200];
		indxAutori = 0;
		indxLibri = 0;
		indxUtenti = 0;
		indxbibliot = 0;
	}
	
    
    public void addUser(String nomeUtente) throws PersonException, LibraryException {
    	if (findUser(nomeUtente) != -1) throw new LibraryException("utente gia registrato");
    	addPersona(new User(nomeUtente), utenti, indxUtenti);
    	indxUtenti++;
    }

    public void addAuthor(String nomeAutore) throws PersonException, LibraryException {
    	if (findAuthor(nomeAutore) != -1) throw new LibraryException("autore gia registrato");

    	addPersona(new Author(nomeAutore), autori, indxAutori);
    	indxAutori++;
    }

    public void addLibrarian(String nomeBibliotecario) throws PersonException, LibraryException {
   		if (findLibrarian(nomeBibliotecario) != -1) throw new LibraryException("bibliotecario gia registrato");
 
    	addPersona(new Librarian(nomeBibliotecario, this), bibliotecari, indxbibliot);
    	indxbibliot++;
    }

	private void addPersona(Person itm, Person[] vet, int indx)throws LibraryException {
     	if (indx == vet.length) throw new LibraryException ("Troppe persone");
		vet[indx] = itm;
    }

    public void addBook(String titolo) throws BookException, LibraryException {
    	if (indxLibri == libri.length) throw new BookException("Troppi libri");
		libri[indxLibri] = new Book(titolo);
		indxLibri++;
    }

    public void deleteBook(String titolo) throws BookException {
    	int i, j, k;
    	Book app = new Book(titolo);
    	
    	i = findBook(titolo);
    	if (i==-1) throw new BookException("Libro non Trovato");
    	// elimina libro dalla lista dei libri
    	indxLibri--;
        for (;i<indxLibri; i++) libri[i]=libri[i+1];
        //...dagli utenti
        for (j = 0; j<indxUtenti; j++) utenti[j].eliminaLibroSeEsiste(app);
        // ...dagli autori
        for (k = 0; k<indxAutori; k++) autori[k].eliminaLibroSeEsiste(app);
        
    }

	public void deleteAuthor(String nome) throws PersonException {
    	Author app;
    	Book appBook[];
    	
    	int i;
    	int j;
    	int indx;
    	int numLibri;
    	
    	indx = findAuthor(nome);
    	if (indx == -1) throw new PersonException("autore non trovato");
    	app = autori[indx];
    	numLibri = app.numLibriScritti();
        appBook = new Book[numLibri];
        
    	try{
			for (i = 0; i<numLibri; i++) {
				appBook[i] = app.getLibroScritto(0);
			    removeAssociationAuthorBook(nome, appBook[i].getTitle()); 
			    deleteBook(appBook[i].getTitle());
			}
			
    	    deletePerson(app, autori, indxAutori);
    	    indxAutori--;
    	} catch (Exception e){}
    
    	for (i = 0; i<numLibri; i++)
	    	for (j = 0; j<indxLibri; j++)
    			utenti[j].eliminaLibroSeEsiste(appBook[i]);
    }
	
	public void deleteUser(String nome) throws PersonException {
    	User app;
    	int i;
    	int indx;
    	int numLibri;
    	
    	indx = findUser(nome);
    	if (indx == -1) throw new PersonException("utente non trovato");
    	app = utenti[indx];
    	numLibri = app.numLibriinPrestito();
    	try{
    	    for (i = 0; i<numLibri; i++) app.restituzione(app.getLibroInPrestito(0));
    	    
    	    deletePerson(app, utenti, indxUtenti);
    	    indxUtenti--;
    	} catch (Exception e){}
    }
	
	private void deletePerson(Person itm, Person[] vet, int indx)throws PersonException{
        int i = 0;
    	while ((i<indx) && (!vet[i].equals(itm))) i++;
    	if (i==indx) throw new PersonException("Persona non Trovata");
    	indx--;
        for (;i<indx; i++) vet[i]=vet[i+1];
    }
    
    public void associateAuthorBook (String author, String title) throws BookException, PersonException{
     int indautore;
     int indlibro;
     
     indautore = findAuthor(author);
     indlibro = findBook(title);
     
     if (indautore==-1) throw new PersonException("Autore Non Trovato");
     if (indlibro==-1) throw new BookException("book Non Trovato");
     
     autori[indautore].addLibroScritto(libri[indlibro]); 
    }

    public void removeAssociationAuthorBook (String author, String title) throws BookException, PersonException{
     int indautore;
     int indlibro;
     
     indautore = findAuthor(author);
     indlibro = findBook(title);
     
     if (indautore==-1) throw new PersonException("Autore Non Trovato");
     if (indlibro==-1) throw new BookException("book Non Trovato");

     autori[indautore].delLibroScritto(libri[indlibro]); 
    }

    public void prestito (String nome, String title) throws BookException, PersonException{
     int induser;
     int indlibro;
     
     induser = findUser(nome);
     indlibro = findBook(title);
     
     if (induser==-1) throw new PersonException("Utente Non Trovato");
     if (indlibro==-1) throw new BookException("book Non Trovato");

     utenti[induser].prestito(libri[indlibro]); 

    }

    public void restituzioneLibro (String nome, String title) throws BookException, PersonException{
     int induser;
     int indlibro;
     
     induser = findUser(nome);
     indlibro = findBook(title);
     
     if (induser==-1) throw new PersonException("Utente Non Trovato");
     if (indlibro==-1) throw new BookException("book Non Trovato");

     utenti[induser].restituzione(libri[indlibro]); 
    }

	public void salva(String NomeFile) throws IOException{
		int i;
		FileWriter out = null;
		
		out = new FileWriter(NomeFile, false);
		for (i=0; i<indxUtenti; i++) out.write(utenti[i]+"\n");
		out.close();
    }

//---------------------------------------------------------------------------------------------------
    
    private int findPerson(Person key, Person[] vet, int indx){
    	int i = 0;
    	while ((i<indx) && (!vet[i].equals(key))) i++;
    	if (i<indx) return i;
    	else return -1;
    }
    
    private int findUser(String nomeUtente) {
    	return findPerson(new User(nomeUtente), utenti, indxUtenti);
    }

    private int findAuthor(String nomeAutore) {
    	return findPerson(new Author(nomeAutore), autori, indxAutori);
    }

    private int findLibrarian(String nomeBibliotecario) {
    	return findPerson(new Librarian(nomeBibliotecario, this), bibliotecari, indxbibliot);
    }
    
    private int findBook(String titolo){
    	int i = 0;
    	Book key = new Book(titolo);
    	
    	while ((i<indxLibri) && (!libri[i].equals(key))) i++;
    	if (i<indxLibri) return i;
    	else return -1;
    }
    
    public String toString(){
    	String app="UTENTI\n";
    	int i; 
    	
    	for (i=0; i<indxUtenti; i++) app = app+utenti[i]+"\n";
    	
    	app = app+"AUTORI\n";
    	for (i=0; i<indxAutori; i++) app = app+autori[i]+"\n";
    	
    	app = app+"LIBRI\n";
    	for (i=0; i<indxLibri; i++) app = app+libri[i]+"\n";
    	
    	return app;
    }  
}
