
public class User extends Person{
	private Book[] libri;
    int indexLibri;
    private static int codice = 0; 
	private int cod;

	public User(String name, int mxLibriPrestito) {
 		super(name);
 		libri = new Book[mxLibriPrestito];
 		indexLibri = 0;
 		cod = codice;
 		codice++;
	}
	
	public User(String name) {
 		super(name);
 		libri = new Book[3];
 		indexLibri = 0;
 		cod = codice;
 		codice++;
	}

	public void prestito(Book bk) throws PersonException, BookException{
		if (indexLibri == libri.length) throw new PersonException("Troppi libri");
		libri[indexLibri] = bk;
		bk.presta();
		indexLibri++;
	}
	
	public void restituzione(Book bk) throws PersonException, BookException{
		int i=0; 
		while ((i<indexLibri) && (!libri[i].equals(bk))) i++;
		if (i==indexLibri) throw new PersonException("Libro non Trovato");
        bk.restituisci();
        indexLibri--;
        for (;i<indexLibri; i++) libri[i]=libri[i+1];
	}

	public Book getLibroInPrestito(int indx) throws PersonException {
		if ((indx<0) || (indx>=indexLibri)) throw new PersonException("Libro non Trovato");
		return libri[indx];
	}
	
	public int numLibriinPrestito(){return indexLibri;}

	public int getCodiceTessera(){return cod;}
	
	public void eliminaLibroSeEsiste(Book bk){   
		int i=0; 
		while ((i<indexLibri) && (!libri[i].equals(bk))) i++;
		if (i==indexLibri) return;
        indexLibri--;
        for (;i<indexLibri; i++) libri[i]=libri[i+1];
	}
	
	public String toString(){
	  String app = super.toString();
	  int i;
	  
	  for (i=0; i<indexLibri; i++) app= app+", "+libri[i];
	  return app;
	}
	
}