
public class Author extends Person{
	private Book[] libri;
    int indexLibri;
     
	public Author(String name, int mxLibriScritti) {
 		super(name);
 		libri = new Book[mxLibriScritti];
 		indexLibri = 0;
	}
	
	public Author(String name) {
 		super(name);
 		libri = new Book[200];
 		indexLibri = 0;
	}

	public void addLibroScritto(Book bk) throws PersonException{
		if (indexLibri == libri.length) throw new PersonException("Troppi libri");
		libri[indexLibri] = bk;
		indexLibri++;
	}
	
	public void delLibroScritto(Book bk) throws PersonException{
		int i=0; 
		while ((i<indexLibri) && (!libri[i].equals(bk))) i++;
		if (i==indexLibri) throw new PersonException("Libro non Trovato");
        indexLibri--;
        for (;i<indexLibri; i++) libri[i]=libri[i+1];
	}


	public Book getLibroScritto(int indx) throws PersonException {
		if ((indx<0) || (indx>=indexLibri)) throw new PersonException("Libro non Trovato");
		return libri[indx];
	}
	
	public int numLibriScritti(){return indexLibri;}
	
	public void eliminaLibroSeEsiste(Book bk){   
		int i=0; 
		while ((i<indexLibri) && (!libri[i].equals(bk))) i++;
		if (i==indexLibri) return;
        indexLibri--;
        for (;i<indexLibri; i++) libri[i]=libri[i+1];
	}
	
	public String toString(){
	  String app = super.toString();
	  int i;
	  
	  for (i=0; i<indexLibri; i++) app= app+", "+libri[i];
	  return app;
	}
}
