/**
 * Istruzione packege che sancisce dove sar reperibile questa classe
*/
package esercitazioni.orologio;
/**
 * come rendere accessibile la classe Counter che abbiamo situato
 * in un packege differente da quello corrente ?
 */
import esercitazioni.counter.*;

public class Orologio {
    /**
     * dichiarazione di un oggetto di classe Counter con
     * la funzione di mantenere memorizzato il valore delle ore
    */
    private esercitazioni.counter.Counter ora;

    /**
     * dichiarazione di un oggetto di classe Counter con
     * la funzione di mantenere memorizzato il valore dei minuti
    */
    private Counter minuti;

    /**
     * Si sfrutta la caratteristica dei metodi costruttore per compiere
     * la creazione esplicita degli attributi ore e minuti
     */
    public Orologio() {
           //creazione dell'oggetto ora
           ora= new Counter();
           //creazione dell'oggetto minuti
           minuti=new Counter();

    }
    /**
     * Costruttore che permetta di inizializzare
     * ad un certo orario l'orologio in fase d inizializzazione
     */
    public Orologio(int o, int m) {
           //creazione dell'oggetto ora
           ora= new Counter(o);
           //creazione dell'oggetto minuti
           minuti=new Counter(m);

    }

     /**
     * metodo che consente l'avanzamento dell'ora un minuto alla volta
     */
     public void ticM(){
            minuti.inc();
            check();
     }

     /**
     * Overloading del metodo ticM  che imposta direttamente il valore dei minuti
     */
     public void ticM(int m){
            minuti.set(m);
            check();
     }

     /**
     * metodo che consente l'avanzamento dell'ora un'ora alla volta
     */
     public void ticH(){
            ora.inc();
            check();
     }

     /**
     * Overloading del metodo ticH che consente di impostare direttamente
     * il valore dell'ora
     */
     public void ticH(int h){
            ora.set(h);
            check();
     }

     /**
      * Controlla che il valore di ore e minuti sia congruo, ovvero
      * che ore non superi 24 e non sia inferiore a 0 e che minuti
      * sia compreso tra 0 e 59
      */
      private void check(){
            if(minuti.getValue()>59){
                /*se i minuti hanno raggiunto il
                valore di 60 azzero i minuti e incremento
                il valore dell'ora
                */
                minuti.reset();
                //incremento l'ora
                ora.inc();
            }else if(minuti.getValue()<0){
                  minuti.reset();
            }
            /*controllo se l'ora  arrivata a 24*/
            if(ora.getValue()>23){
                ora.reset();
            }else if(ora.getValue()<0){
                  ora.reset();
            }
      }
     /**
      * metodo che permette l'azzeramento dei valori dell'orologio
      */
     public void reset(){
            //azzera l'ora
            ora.reset();
            //azzera i minuti
            minuti.reset();
     }

     /**
      * metodo che permette di conoscere il valore delle ore
      */
      public int getOre(){
             return ora.getValue();
      }

      /**
       * metodo che permette di conoscere il valore dei minuti
       */
      public int getMinuti(){
             return minuti.getValue();
      }
}