package esercitazioni.monitor;
/** Java class "MonitorColori.java" generated from Poseidon for UML.
*  Poseidon for UML is developed by <A HREF="http://www.gentleware.com">Gentleware</A>.
*  Generated with <A HREF="http://jakarta.apache.org/velocity/">velocity</A> template engine.
*/
import java.lang.String;
import java.util.*;

/**
*Estensione della classe Monitor per potere gestire il colore
* in un monitor a colori. L'ereditariet consente di "possesdere"
* le funzionalit viste per la superclasse
*/
public class MonitorColori extends Monitor {
	/**
	* Mantiene lo stato corrente dell'attributo colore
	*/
	int colore;
	/**
	* Array che mantiene nel primo elemento il valore di default
	* e nei restanti tre i tre valori memorizzati relativamente
	* all'attributo colore
	*/
	int[] mem_col;

	/**
	* Il costruttore provvede ad alcune inizializzazioni:
	* - alloca gli elementi degli array per memorie e default
	* - inizializza le memorie e lo stato corrente al valore di default
	* Il costruttore della superclasse assicura le restanti inizializzazioni.
	* Notare che non abbiamo alcun bisogno di conoscere come nella superclasse
	* siano gestiti contrasto e luminosita
	*/
	public MonitorColori() {
		//alloca elementi dell'array che conterr i valori
		//delle memorie e di default
		mem_col=new int[4];
		//imposta il valore di default per il colore
		setColore(200000);
		//inizializza le memorie ed il valori di default
		for(int i=0; i<mem_col.length; i++)
			mem_col[i]=getColore();
	} // end MonitorColori

	/**
	*ritorna il valore corrente dell'attributo colore
	*/
	public int getColore() {
		return colore;
	} // end getColore

	/**
	*Imposta il valore corrente dell'attributo colore
	*/
	public void setColore(int col) {
		colore=normalize(col);
	} // end setColore

	/**
	* esegue una normalizzazione del valore del colore.
	* Dal momento che il metodo pow ritorna un valore double
	*  necessario effettuare un cast
	*/
	private int normalize(int val){
		if(val<0)
			val=0;
		else if(val>(int)(Math.pow(2, 16)))
			val=(int)(Math.pow(2, 16));
		//
		return val;
	}
	/**
	*Imposta il valore corrente del colore e degli attributi definiti
	* nella superclasse (vedi super.setMemoria(nmem)) al valore
	* della memoria corrispondente all'elemento nmem dell'array
	*/
	public void setMemoria(int nmem) {
		if((nmem>=0)&&(nmem<mem_col.length)){
			super.setMemoria(nmem);
			setColore(mem_col[nmem]);
		}
	} // end setMemoria

	/**
	*Salva nell'elemento nmem dell'aray delle memorie lo stato corrente della classe.
	* Notare anche qui l'overriding con chiamata al metodo della superclasse
	*/
	public void salvaMemoria(int nmem) {
		if((nmem>0)&&(nmem<4)){
			super.salvaMemoria(nmem);
			mem_col[nmem]=getColore();
		}
	} // end salvaMemoria

	/**
	*dopo avere chiamato il metodo della superclasse appende al valore
	* ritornato lo stato del colore
	*/
	public String toString() {
		String stato=super.toString();
		return stato+"\nil colore  impostato a "+getColore();
	} // end toString

} // end MonitorColori

