package esercitazioni.monitor;
/** Java class "Monitor.java" generated from Poseidon for UML.
*  Poseidon for UML is developed by <A HREF="http://www.gentleware.com">Gentleware</A>.
*  Generated with <A HREF="http://jakarta.apache.org/velocity/">velocity</A> template engine.
*/
import java.lang.String;
import java.util.*;

/**
* <p>
*Questa classe si prefigge di simulare le funzionalit di base del monitor
* di un computer.
* </p>
*/
public class Monitor {
	/**
	* Variabile privata che registra lo stato acceso/spento
	*/
	private boolean on;
	/**
	* Mantiene lo stato corrente della classe relativamente all'attributo
	* luminosit
	*/
	private int luminosita;
	/**
	* Mantiene lo stato corrente della classe relativamente all'attributo
	* contrasto
	*/
	private int contrasto;
	/**
	* Array che mantiene nel primo elemento il valore di default
	* e nei restanti tre i tre valori memorizzati relativamente
	* all'attributo luminosit
	*/
	private int[] mem_lum;
	/**
	* Array che mantiene nel primo elemento il valore di default
	* e nei restanti tre i tre valori memorizzati relativamente
	* all'attributo contrasto
	*/
	private int[] mem_cont;

	/**
	* <p>
	* Il costruttore provvede ad alcune inizializzazioni:
	* - alloca gli elementi degli array per memorie e default
	* - setta lo stato di acceso
	* - inizializza le memorie e lo stato corrente al valore di default
	* </p>
	*
	*/
	public Monitor() {
		//
		mem_cont=new int[4];
		mem_lum=new int[4];
		//
		accendi();
		//
		setContrasto(50);
		setLuminosita(50);
		for(int i=0;i<mem_cont.length;i++){
		mem_cont[i]=getContrasto();
		mem_lum[i]=getLuminosita();
		}
	} // end Monitor
	/**
	* simula l'accensione del video
	*/
	public void accendi() {
		on=true;
	}
	/**
	* simula lo spegnimento del video
	*/
	public void spegni() {
		on=false;
	}
	/**
	* Imposta il valore corrente di luminosit
	*/
	public void setLuminosita(int lum) {
		luminosita=normalize(lum);
	} // end setLuminosita
	/**
	*Imposta il valore corrente per il contrasto
	*/
	public void setContrasto(int lum) {
		contrasto=normalize(lum);
	} // end contrasto
	/**
	*ritorna un valore normalizzato tra 0 e 100 sulla base del valore
	*passato come parametro
	*/
	private int normalize(int val){
		if(val<0)
			val=0;
		else if(val>100)
			val=100;
		//
		return val;
	}
	/**
	* ritorna il valore corrente dell'attributo luminosita
	*/
	public int getLuminosita() {
		return luminosita;
	} // end getLuminosita
	/**
	* ritorna il valore corrente dell'attributo contrasto
	*/
	public int getContrasto() {
		return contrasto;
	} // end getContrasto
	/**
	*Imposta lo stato corrente con il valore della memoria corrispondente
	*al valore passato come parametro: notare che passando 0 si ripristinano
	*i valori di default
	*/
	public void setMemoria(int nmem) {
		//test del campo di validit degli indici degli array.
		if((nmem>=0)&&(nmem<mem_cont.length)){
			setContrasto(mem_cont[nmem]);
			setLuminosita(mem_lum[nmem]);
		}
	} // end setMemoria

	/**
	*salva lo stato corrente del video relativamente a luminosit e contrasto
	*nella memoria corrispondente al parametro nmem. Il test di validit
	*dell'indice impedisce di scrivere sui valori di deafult
	*/
	public void salvaMemoria(int nmem) {
		if((nmem>0)&&(nmem<mem_cont.length)){
			mem_cont[nmem]=getContrasto();
			mem_lum[nmem]=getLuminosita();
		}
	} // end salvaMemoria
	/**
	*
	*/
	public String toString() {
		String stato="Il Monitor  ";
		if(on)
			stato+="acceso ";
		else
			stato+="spento ";
		//
		stato+="\nla luminosit  impostata a "+getLuminosita();
		stato+="\nil contrasto  impostato a "+getContrasto();
		//
		return stato;
	} // end toString

} // end Monitor

