package esercitazioni.animali;
//
import java.io.*;
import java.util.StringTokenizer;
import esercitazioni.io.*;

public class Enciclopedia {

    private Animale[] schede;
    private int n;
    /**
     *
     */
    public Enciclopedia(int max) {
           n=0;
           schede=new Animale[max];

    }
    /**
     *
     */
    public void aggiungi(Animale a){
           schede[n]=a;
           n++;
    }
    /**
     *
     */
    public Animale cerca(String nm){
           for(int i=0;i<n;i++){
                   if(nm.equals(schede[i].getNome())){
                        return schede[i];
                   }
           }
           //
           return null;
    }
    /**
     * metodo che deve implementare un loop per la ricerca
     * delle schede
     */
     public void findSchede(){
           //oggetto che permette di leggere dalla tastiera
           //l'input dell'utente
           Tastiera t=new Tastiera();
           String st;
           do{
              System.out.println("Scegli '*' per uscire o premi un tasto per continuare;");
              st=t.readLine();
              if(!st.startsWith("*")){
                //preosegue per inserire una nuova scheda
                System.out.println("Quale animale devo cercare?");
                String ins=t.readLine();
                Animale a=cerca(ins);
                if(a!=null)
                    System.out.println(a.toString());
                else
                    System.out.println("Animale "+ ins+" non trovato");
              }
           }while(!st.startsWith("*"));
     }
    /**
     * metodo che deve implementare un loop per l'aggiunta
     * manuale delle schede
     */
     public void inputSchede(){
           //oggetto che permette di leggere dalla tastiera
           //l'input dell'utente
           Tastiera t=new Tastiera();
           String st;
           do{
              System.out.println("Scegli '*' per uscire o premi un tasto per continuare;");
              st=t.readLine();
              if(!st.startsWith("*")){
                //preosegue per inserire una nuova scheda
                System.out.println("Scegli 'U' per inserire un uccello;");
                System.out.println("Scegli 'P' per inserire un pesce;");
                System.out.println("Scegli 'M' per inserire un mammifero;");
                String ins=t.readLine();
                if(ins.equalsIgnoreCase("U")){
                    System.out.print("Inserisci il nome dell'uccello: ");
                    aggiungi(new Uccello(t.readLine()));
                }else if(ins.equalsIgnoreCase("P")){
                    System.out.print("Inserisci il nome del pesce: ");
                    aggiungi(new Pesce(t.readLine()));
                }else if(ins.equalsIgnoreCase("M")){
                    System.out.print("Inserisci il nome del mammifero: ");
                    aggiungi(new Mammifero(t.readLine()));
                }
              }
           }while(!st.startsWith("*"));
     }
     /**
      * metodo che deve implementare la lettura delle schede
      * da un file
      */
      public void loadFile(String flnm){
        try{
             FileReader fr=new FileReader(flnm);
             BufferedReader infile=new BufferedReader(fr);
             StringTokenizer st;
             String line=infile.readLine();
             String tipo;
             while(line!=null){
                System.out.println("linea= "+line);
                st=new StringTokenizer(line, ",");
                tipo=st.nextToken();
                if(tipo.equals("MAMMIFERO")){
                    aggiungi(new Mammifero(st.nextToken()));
                } else if(tipo.equals("PESCE")){
                    aggiungi(new Pesce(st.nextToken()));
                } else if(tipo.equals("UCCELLO")){
                    aggiungi(new Uccello(st.nextToken()));
                }
                //
                line=infile.readLine();
             }
             //
             infile.close();
         }catch (IOException e){}
      }
    /**
     * metodo che deve salvare su file le schede attualmente caricate.
     * Al termine della fase di caricamento si deve avere aggiornato il numero
     * di schede letto in corrispondenza dell'attributo n
     */
    public void saveFile(String flnm) throws IOException{
           FileWriter fw=new FileWriter(flnm);
           PrintWriter outfile=new PrintWriter(fw);
           for(int i=0;i<n;i++){
                outfile.println(schede[i].getTipo()+","+schede[i].getNome());
           }
           outfile.close();
    }
    /**
     * Stampa tutte le schede
     */
    public void stampa(){
           for(int i=0;i<n;i++){
                System.out.println(schede[i].toString());
           }
    }

}