/**
 *
 * Questa istruzione indica l'appartenenza ad un pakage: il pakage di cui fa
 * parte la classe Counter  esercitazioni.counter. In altre parole  come dire
 * che quando vogliamo istanziare questa classe dall'interno di un'altra (ad esempio
 * dall'interno di una classe che contenga il metodo main) il sistema deve cercarla
 * in una dirtectory esercitazioni\counter. Dopo avere creato questa classe, provate
 * a guardare sul disco a partire da (nel caso ovviamente del computer su cui si svolgono
 * le esercitazioni) c:\TEMP\fondLB-inf\src che rappresenta la directory "radice"
 * per il nostro progetto, e vi troverete la struttura di albero di directory
 * \esercitazioni\counter\Counter.java: quest'ultima parte da una idea di che cosa
 * sia il nostro pakage. Adeguatamente "informata", e vedremo successivamente come farlo,
 * una classe potr trovarne un'altra per poterla dichiarare, istanziare e quindi
 * usarne metodi e attributi.
 */
package esercitazioni.counter;
//
/**
 * L'istruzione che segue indica la dichiarazione di una classe
 * Il qualificatore public indica che la classe potr essere istanziata
 * da qualsiasi altra: usremo quasi sempre classi pubbliche.
 * La parola class indica che staimo facendo una dichiarazione di classe
 * il cui nome  Counter. L'ambito compreso tra la prima parentesi { e
 * l'ultima parentesi }, rappresenta l'area del nostro codice in cui si
 * definiscono attributi e metodi della classe, in altre parole il suo stato
 * (specificato dai suoi attributi) ed il suo comportamento (definito dai suoi
 * metodi)
 */
public class Counter {
    /**
     * Area di dichiarazione degli attributi. Successivamente si delinea
     * un'area in cui si specificano delle varaibili membro della classe.
     * Non esiste alcun vincolo a mettere queste dichiarazioni all'inizio
     * della classe,  sufficiente che risiedano all'interno delle due parentesi
     * {...} che definiscono l'area di dichiarazione della classe, ma per mantenere
     * un minimo di ordine consigliabile farlo qui.
     * Viene dichiarata inizialmente un solo attributo, il qualificatore
     * private indica che val pu essere usato solo dai metodi di questa classe;
     * ci per rendere esplicito il concetto di incapsulamento proprio della
     * programmazione ad oggetti. Il tipo di dato  un intero (int)
     */
    private int val;

    /**
     * Area di dichiarazione dei metodi della classe.
     * Il primo metodo che dichiariamo qui  il costruttore, ovvero quel metodo
     * che viene sempre chiamato al momento in cui una classe viene istanziata.
     * Attraverso tale metodo  possibile effettuare le inizializzazioni del caso.
     * E' consigliabile sempre dichiarare il costruttore anche se questo non  reso
     * obbligatorio dallo standard java che in caso contrario ne crea uno automaticamente.
     *
     */
    public Counter() {
    }

    /**
     *
     */
    public void reset(){
           val=0;
    }

    /**
     *
     */
    public void inc(){
           val++;
    }

    /**
     *
     */
    public int getValue(){
           return val;
    }
}