/*
 * Decompiled with CFR 0.152.
 */
package aima.test.tvenvironmenttest;

import aima.basic.BasicEnvironmentView;
import aima.basic.vaccum.ReflexVaccumAgent;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import junit.framework.TestCase;

public class ReflexVaccumAgentTest
extends TestCase {
    private ReflexVaccumAgent agent;
    private StringBuffer envChanges;

    public void setUp() {
        this.agent = new ReflexVaccumAgent();
        this.envChanges = new StringBuffer();
    }

    public void testCleanClean() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Clean", "Clean");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.step(8);
        ReflexVaccumAgentTest.assertEquals((String)"RightLeftRightLeftRightLeftRightLeft", (String)this.envChanges.toString());
    }

    public void testCleanDirty() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Clean", "Dirty");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.step(8);
        ReflexVaccumAgentTest.assertEquals((String)"RightSuckLeftRightLeftRightLeftRight", (String)this.envChanges.toString());
    }

    public void testDirtyClean() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Dirty", "Clean");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.step(8);
        ReflexVaccumAgentTest.assertEquals((String)"SuckRightLeftRightLeftRightLeftRight", (String)this.envChanges.toString());
    }

    public void testDirtyDirty() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Dirty", "Dirty");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.step(8);
        ReflexVaccumAgentTest.assertEquals((String)"SuckRightSuckLeftRightLeftRightLeft", (String)this.envChanges.toString());
    }
}

