/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.nqueens;

import aima.basic.XYLocation;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import junit.framework.TestCase;

public class NQueensGoalTestTest
extends TestCase {
    NQueensGoalTest goalTest;
    NQueensBoard board;

    public void setUp() {
        this.goalTest = new NQueensGoalTest();
        this.board = new NQueensBoard(8);
    }

    public void testEmptyBoard() {
        NQueensGoalTestTest.assertFalse((boolean)this.goalTest.isGoalState(this.board));
    }

    public void testSingleSquareBoard() {
        this.board = new NQueensBoard(1);
        NQueensGoalTestTest.assertFalse((boolean)this.goalTest.isGoalState(this.board));
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensGoalTestTest.assertTrue((boolean)this.goalTest.isGoalState(this.board));
    }

    public void testInCorrectPlacement() {
        NQueensGoalTestTest.assertFalse((boolean)this.goalTest.isGoalState(this.board));
        this.board.addQueenAt(new XYLocation(0, 0));
        this.board.addQueenAt(new XYLocation(1, 2));
        this.board.addQueenAt(new XYLocation(2, 4));
        this.board.addQueenAt(new XYLocation(3, 6));
        this.board.addQueenAt(new XYLocation(4, 1));
        this.board.addQueenAt(new XYLocation(5, 3));
        this.board.addQueenAt(new XYLocation(6, 5));
        this.board.addQueenAt(new XYLocation(7, 7));
        NQueensGoalTestTest.assertFalse((boolean)this.goalTest.isGoalState(this.board));
    }

    public void testCorrectPlacement() {
        NQueensGoalTestTest.assertFalse((boolean)this.goalTest.isGoalState(this.board));
        this.board.addQueenAt(new XYLocation(0, 1));
        this.board.addQueenAt(new XYLocation(1, 4));
        this.board.addQueenAt(new XYLocation(2, 6));
        this.board.addQueenAt(new XYLocation(3, 3));
        this.board.addQueenAt(new XYLocation(4, 0));
        this.board.addQueenAt(new XYLocation(5, 7));
        this.board.addQueenAt(new XYLocation(6, 5));
        this.board.addQueenAt(new XYLocation(7, 2));
        NQueensGoalTestTest.assertTrue((boolean)this.goalTest.isGoalState(this.board));
    }
}

