/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.nqueens;

import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensFitnessFunction;
import java.util.Set;
import junit.framework.TestCase;

public class NQueensFitnessFunctionTest
extends TestCase {
    NQueensFitnessFunction fitnessFunction;

    public void setUp() {
        this.fitnessFunction = new NQueensFitnessFunction();
    }

    public void test_getValue() {
        NQueensFitnessFunctionTest.assertTrue((0.0 == this.fitnessFunction.getValue("00000000") ? 1 : 0) != 0);
        NQueensFitnessFunctionTest.assertTrue((0.0 == this.fitnessFunction.getValue("01234567") ? 1 : 0) != 0);
        NQueensFitnessFunctionTest.assertTrue((0.0 == this.fitnessFunction.getValue("76543210") ? 1 : 0) != 0);
        NQueensFitnessFunctionTest.assertTrue((23.0 == this.fitnessFunction.getValue("56136477") ? 1 : 0) != 0);
        NQueensFitnessFunctionTest.assertTrue((28.0 == this.fitnessFunction.getValue("04752613") ? 1 : 0) != 0);
    }

    public void test_isGoalState() {
        NQueensFitnessFunctionTest.assertTrue((boolean)this.fitnessFunction.isGoalState("04752613"));
        NQueensFitnessFunctionTest.assertFalse((boolean)this.fitnessFunction.isGoalState("00000000"));
        NQueensFitnessFunctionTest.assertFalse((boolean)this.fitnessFunction.isGoalState("56136477"));
    }

    public void test_getBoardForIndividual() {
        NQueensBoard nQueensBoard = this.fitnessFunction.getBoardForIndividual("56136477");
        NQueensFitnessFunctionTest.assertEquals((String)" -  -  -  -  -  -  -  - \n -  -  Q  -  -  -  -  - \n -  -  -  -  -  -  -  - \n -  -  -  Q  -  -  -  - \n -  -  -  -  -  Q  -  - \n Q  -  -  -  -  -  -  - \n -  Q  -  -  Q  -  -  - \n -  -  -  -  -  -  Q  Q \n", (String)nQueensBoard.getBoardPic());
        NQueensFitnessFunctionTest.assertEquals((String)"--------\n--Q-----\n--------\n---Q----\n-----Q--\nQ-------\n-Q--Q---\n------QQ\n", (String)nQueensBoard.toString());
    }

    public void test_generateRandomIndividual() {
        for (int i = 2; i <= 36; ++i) {
            String string = this.fitnessFunction.generateRandomIndividual(i);
            NQueensFitnessFunctionTest.assertEquals((int)i, (int)string.length());
        }
    }

    public void test_getFiniteAlphabet() {
        for (int i = 2; i <= 36; ++i) {
            Set<Character> set = this.fitnessFunction.getFiniteAlphabetForBoardOfSize(i);
            NQueensFitnessFunctionTest.assertEquals((int)i, (int)set.size());
        }
    }
}

