/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.search.framework.Successor;
import aima.search.map.ExtendableMap;
import aima.search.map.MapSuccessorFunction;
import java.util.ArrayList;
import junit.framework.TestCase;

public class MapSuccessorFunctionTest
extends TestCase {
    MapSuccessorFunction msf;

    public void setUp() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("A", "C", 6.0);
        extendableMap.addBidirectionalLink("B", "C", 4.0);
        extendableMap.addBidirectionalLink("C", "D", 7.0);
        extendableMap.addUnidirectionalLink("B", "E", 14.0);
        this.msf = new MapSuccessorFunction(extendableMap);
    }

    public void testSuccessors() {
        Successor successor;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.clear();
        arrayList.add("B");
        arrayList.add("C");
        for (Object e : this.msf.getSuccessors("A")) {
            successor = (Successor)e;
            MapSuccessorFunctionTest.assertTrue((arrayList.contains(successor.getAction()) && arrayList.contains(successor.getState()) ? 1 : 0) != 0);
        }
        arrayList.clear();
        arrayList.add("A");
        arrayList.add("C");
        arrayList.add("E");
        for (Object e : this.msf.getSuccessors("B")) {
            successor = (Successor)e;
            MapSuccessorFunctionTest.assertTrue((arrayList.contains(successor.getAction()) && arrayList.contains(successor.getState()) ? 1 : 0) != 0);
        }
        arrayList.clear();
        arrayList.add("A");
        arrayList.add("B");
        arrayList.add("D");
        for (Object e : this.msf.getSuccessors("C")) {
            successor = (Successor)e;
            MapSuccessorFunctionTest.assertTrue((arrayList.contains(successor.getAction()) && arrayList.contains(successor.getState()) ? 1 : 0) != 0);
        }
        arrayList.clear();
        arrayList.add("C");
        for (Object e : this.msf.getSuccessors("D")) {
            successor = (Successor)e;
            MapSuccessorFunctionTest.assertTrue((arrayList.contains(successor.getAction()) && arrayList.contains(successor.getState()) ? 1 : 0) != 0);
        }
        arrayList.clear();
        MapSuccessorFunctionTest.assertTrue((0 == this.msf.getSuccessors("E").size() ? 1 : 0) != 0);
    }
}

